#include <iostream>
#include <unordered_map>
#include <algorithm>
using namespace std;

const int MOD = 1000000007;

long long modinv(long long a, long long mod) {
    return pow(a, mod - 2) % mod;
}

long long solve() {
    int t;
    cin >> t;
    
    while (t--) {
        int p, m;
        cin >> p >> m;
        
        if (p == 0) {
            cout << 0 << endl;
            continue;
        }
        
        // Fast iterative DP: process states by total socks drawn
        int total_socks = 2 * p + m;
        unordered_map<pair<int, int>, long long, hash<pair<int, int>>> dp;
        
        // Process states in reverse order (from most socks drawn to least)
        for (int socks_drawn = total_socks; socks_drawn >= 0; socks_drawn--) {
            for (int pairs_started = 0; pairs_started <= min(p, socks_drawn); pairs_started++) {
                int singles_drawn = socks_drawn - pairs_started;
                if (singles_drawn > m || singles_drawn < 0) {
                    continue;
                }
                
                int remaining_socks = total_socks - socks_drawn;
                
                if (remaining_socks <= 0) {
                    dp[{pairs_started, singles_drawn}] = 0;
                } else if (pairs_started > 0 && pairs_started == remaining_socks) {
                    dp[{pairs_started, singles_drawn}] = 1;
                } else {
                    // We draw one sock for sure
                    long long result = 1;
                    
                    // Case 1: Draw a new single sock
                    if (singles_drawn < m) {
                        long long prob_single = ((long long)(m - singles_drawn) * modinv(remaining_socks, MOD)) % MOD;
                        pair<int, int> next_state = {pairs_started, singles_drawn + 1};
                        if (dp.find(next_state) != dp.end()) {
                            result = (result + prob_single * dp[next_state]) % MOD;
                        }
                    }
                    
                    // Case 2: Start a new pair
                    if (pairs_started < p) {
                        long long prob_new_pair = ((long long)(2 * (p - pairs_started)) * modinv(remaining_socks, MOD)) % MOD;
                        pair<int, int> next_state = {pairs_started + 1, singles_drawn};
                        if (dp.find(next_state) != dp.end()) {
                            result = (result + prob_new_pair * dp[next_state]) % MOD;
                        }
                    }
                    
                    dp[{pairs_started, singles_drawn}] = result;
                }
            }
        }
        
        auto it = dp.find({0, 0});
        cout << (it != dp.end() ? it->second : 0) << endl;
    }
    
    return 0;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    return solve();
}
