import sys

def solve_one_number(x0):
    x = x0
    step_count = 0

    while x != 1:
        step_count += 1

        # RANDOM for numbers with many high digits
        s = str(x)
        high_digits = sum(1 for c in s if c >= '7')

        use_random = (
            len(s) >= 5 and
            high_digits >= len(s) // 2 and
            step_count <= 3
        )

        if use_random:
            print("random")
        else:
            print("collatz")

        sys.stdout.flush()

        result = int(input().strip())
        if result == 0:
            return False
        elif result == 1:
            return True
        else:
            x = result

def main():
    t = int(input().strip())
    for _ in range(t):
        x0 = int(input().strip())
        success = solve_one_number(x0)
        if not success:
            break

if __name__ == "__main__":
    main()