import sys

def solve_one_number(x0):
    x = x0
    step_count = 0

    while x != 1:
        step_count += 1

        # Minimal random usage: only for very specific bad cases
        # Use random very rarely and only for numbers that are known problematic
        if (
            x > 5000000 and  # Very large number
            step_count > 80 and  # Many steps already
            step_count % 100 == 0  # Very rarely
        ):
            print("random")
        else:
            print("collatz")

        sys.stdout.flush()

        result = int(input().strip())

        if result == 0:
            return False
        elif result == 1:
            return True
        else:
            x = result

    return True

def main():
    t = int(input().strip())

    for _ in range(t):
        x0 = int(input().strip())
        success = solve_one_number(x0)
        if not success:
            break

if __name__ == "__main__":
    main()