import sys

def count_digits(n):
    return len(str(n))

def solve_one_number(x0):
    x = x0
    step_count = 0

    while x != 1:
        step_count += 1

        # AGGRESSIVE RANDOM strategy
        # Use random frequently for expensive numbers
        digits = count_digits(x)

        use_random = (
            # Large numbers get random more often
            (digits >= 6 and step_count % 8 == 0) or
            (digits >= 5 and step_count % 15 == 0) or
            # Long sequences get random
            (step_count > 100 and step_count % 20 == 0) or
            # Very large numbers get random early
            (digits >= 7 and step_count <= 10)
        )

        if use_random:
            print("random")
        else:
            print("collatz")

        sys.stdout.flush()

        result = int(input().strip())

        if result == 0:
            return False
        elif result == 1:
            return True
        else:
            x = result

def main():
    t = int(input().strip())

    for _ in range(t):
        x0 = int(input().strip())
        success = solve_one_number(x0)
        if not success:
            break

if __name__ == "__main__":
    main()