import sys

def count_digits(n):
    """Count digits in decimal representation of n"""
    return len(str(n))

def collatz(x):
    """Standard Collatz function"""
    if x % 2 == 0:
        return x // 2
    else:
        return 3 * x + 1

def should_try_random(x, step_count, consecutive_increases):
    """
    Decide whether to try the RANDOM operation

    Strategy:
    1. Never use random for small numbers (< 10000)
    2. Use random sparingly for medium numbers (10000-1000000)
    3. Use random more frequently for very large numbers
    4. Use random if we've had many consecutive increases
    """

    # Never use random for small numbers - collatz is efficient enough
    if x < 10000:
        return False

    # For medium numbers, use random very rarely
    if x < 1000000:
        # Only if we've been stuck for a while
        return step_count > 50 and step_count % 30 == 0

    # For large numbers, use random more frequently but still conservatively
    if x < 10000000:
        return step_count % 20 == 0 or consecutive_increases > 5

    # For very large numbers, use random more aggressively
    return step_count % 10 == 0 or consecutive_increases > 3

def solve_one_number(x0):
    """Solve for one starting number x0"""
    x = x0
    step_count = 0
    consecutive_increases = 0
    last_x = x

    while x != 1:
        step_count += 1

        # Track if numbers are growing
        if x > last_x:
            consecutive_increases += 1
        else:
            consecutive_increases = 0

        # Decide which operation to use
        if should_try_random(x, step_count, consecutive_increases):
            print("random")
        else:
            print("collatz")

        sys.stdout.flush()

        # Read the result
        result = int(input().strip())

        if result == 0:
            # Out of tokens
            return False
        elif result == 1:
            # Success!
            return True
        else:
            # Continue with new number
            last_x = x
            x = result

    return True

def main():
    # Read number of test cases
    t = int(input().strip())

    for _ in range(t):
        # Read starting number
        x0 = int(input().strip())

        # Solve this number
        success = solve_one_number(x0)

        if not success:
            # Out of tokens, exit
            break

if __name__ == "__main__":
    main()