#include <vector>
#include <iostream>
#include <climits>
using namespace std;

struct Point {
    long long x, y;
};

int main() {
    ios::sync_with_stdio(false);
    int n;
    if (!(cin >> n)) 
        return 0;
    vector<Point> p(n);
    for (int i = 0; i < n; ++i) 
        cin >> p[i].x >> p[i].y;

    long long best_dist_sq = -1;
    int best_i = -1;
        int best_j = -1;
    for (int i = 0; i < n; ++i) 
    {
        for (int j = i + 1; j < n; ++j) 
        {
            long long dx = p[j].x - p[i].x;
            long long dy = p[j].y - p[i].y;
            long long dist_sq = dx * dx + dy * dy;
            if (dist_sq > best_dist_sq) 
            {
                best_dist_sq = dist_sq;
                best_i = i;
                best_j = j;
            }
        }
    }

    long long a = p[best_j].x - p[best_i].x;
    long long b = p[best_j].y - p[best_i].y;
    long long pmin = LLONG_MAX, pmax = LLONG_MIN;
    for (int k = 0; k < n; ++k) 
    {
        long long val = a * p[k].x + b * p[k].y;
        if (val < pmin) pmin = val;
        if (val > pmax) pmax = val;
    }

    cout << a << " " << b << " " << -pmin << "\n";
    cout << a << " " << b << " " << -pmax << "\n";
    return 0;
}