def solve():
    """
    Решение задачи "Кто я?"
    
    Стратегия:
    1. Первый запуск: выбираем игрока по формуле (sum + 1) % n + 1
    2. Второй запуск: игрок угадывает свою карту по формуле (player - 2 - visible_sum) % total_players
    """
    # Читаем индикатор запуска
    launch = int(input())
    
    if launch == 0:
        # Первый запуск: определяем, какой игрок должен угадать
        n = int(input())
        cards = list(map(int, input().split()))
        
        # Формула для выбора игрока: (сумма всех карт + 1) % n + 1
        total_sum = sum(cards)
        player_to_guess = (total_sum + 1) % n + 1
        print(player_to_guess)
        
    else:
        # Второй запуск: выбранный игрок делает предположение
        player_number = launch
        n = int(input())
        visible_cards = list(map(int, input().split()))
        
        # Вычисляем сумму видимых карт
        visible_sum = sum(visible_cards)
        total_players = n + 1  # n видимых карт + 1 (своя карта)
        
        # Обратная формула для определения недостающей карты:
        # (player_number - 2 - visible_sum) % total_players
        missing_card = (player_number - 2 - visible_sum) % total_players
        print(missing_card)

if __name__ == "__main__":
    solve()
