def solve():
    # Read the launch indicator
    launch = int(input())

    if launch == 0:
        # First launch: determine which player should guess
        n = int(input())
        cards = list(map(int, input().split()))

        # Calculate XOR of all visible cards
        xor_sum = 0
        for card in cards:
            xor_sum ^= card

        # The player who should guess is determined by XOR sum modulo n
        # We add 1 because players are numbered from 1
        player_to_guess = (xor_sum % n) + 1
        print(player_to_guess)

    else:
        # Second launch: the chosen player makes a guess
        player_number = launch
        n = int(input())
        visible_cards = list(map(int, input().split()))

        # Calculate XOR of all visible cards
        visible_xor = 0
        for card in visible_cards:
            visible_xor ^= card

        # The guess is based on the XOR and the player's position
        # We need to reverse the encoding from the first launch
        # The missing card value can be determined by the XOR pattern
        guess = visible_xor ^ ((player_number - 1) % (n + 1))
        print(guess)

if __name__ == "__main__":
    solve()