#include <iostream>
#include <vector>
#include <algorithm>
#include <map>
#include <cmath>
#include <iomanip>
#include <set>
#include <queue>
#include <array>
#include <random>
#include <cstdlib>

typedef long long ll;
typedef unsigned long long ull;
typedef long double ld;
typedef std::vector<ll> vll;
typedef std::pair<ll, ll> pll;
typedef std::set<ll> sll;

#define all(a) a.begin(), a.end()
using std::cin, std::cout;

template <typename T>
std::istream &operator>>(std::istream &input, std::pair<T, T> &data)
{
    input >> data.x >> data.y;
    return input;
}

template <typename T>
std::istream &operator>>(std::istream &input, std::vector<T> &data)
{
    for (T &x : data)
        input >> x;
    return input;
}

std::mt19937 rnd(3457);

template <typename T>
std::ostream &operator<<(std::ostream &output, const std::pair<T, T> &data)
{
    output << data.first << " " << data.second << "\n";
    return output;
}

template <typename T>
std::ostream &operator<<(std::ostream &output, const std::vector<T> &data)
{
    for (const T &x : data)
        output << x << " ";
    return output;
}

std::ostream &operator<<(std::ostream &output, const __int128 &x)
{
    __int128 n = x;
    if (n == 0)
    {
        output << "0";
        return output;
    }
    if (n < 0)
    {
        n = -n;
        output << "-";
    }
    std::string s;
    while (n)
    {
        s += '0' + (n % 10);
        n /= 10;
    }
    reverse(all(s));
    std::cout << s;
    return output;
}

ll div_up(ll a, ll b) { return a / b + ((a ^ b) > 0 && a % b); }   // divide a by b rounded up
ll div_down(ll a, ll b) { return a / b - ((a ^ b) < 0 && a % b); } // divide a by b rounded down
ll math_mod(ll a, ll b) { return a - b * div_down(a, b); }

void acceleration()
{
    std::ios_base::sync_with_stdio(false);
    std::cin.tie();
    std::cout.tie();
}

void formatting()
{
    std::cout << std::fixed;
    std::cout << std::setprecision(6);
    std::cout.precision(6);
}

void solve();

int main()
{
    acceleration();
    formatting();
    solve();
}

ll MOD = 1e9 + 7;

int64_t bin_pow(int64_t residue, int64_t power)
{
    int64_t answer = 1;
    while (power != 0)
    {
        if (power % 2 == 1)
        {
            answer = (answer * residue) % MOD;
        }
        power /= 2;
        residue = (residue * residue) % MOD;
    }
    return answer;
}

ll add(ll x, ll pow)
{
    return ((x % MOD) * pow) % MOD;
}

ll dist(pll a, pll b)
{
    return (a.first - b.first) * (a.first - b.first) + (a.second - b.second) * (a.second - b.second);
}

void solve()
{
    ll t;
    cin >> t;
    vll fact(2e6 + 10, 1);
    vll inv_fact(2e6 + 10, 1);
    for (ll i = 1; i < fact.size(); i++)
    {
        fact[i] = (fact[i - 1] * i) % MOD;
    }
    inv_fact[fact.size() - 1] = bin_pow(fact[fact.size() - 1], MOD - 2);
    for (ll i = inv_fact.size() - 2; i >= 0; i--)
    {
        inv_fact[i] = (inv_fact[i + 1] * (i + 1)) % MOD;
    }
    while (t--)
    {
        ll p, m;
        cin >> p >> m;
        ll ans = 1;
        ans = (ans * fact[p]) % MOD;
        ans = (ans * fact[p]) % MOD;
        ans = (ans * (2 * p + m + 1)) % MOD;
        ans = (ans * bin_pow(2, 2 * p)) % MOD;
        ans = (ans * inv_fact[2 * p + 1]) % MOD;
        cout << ans << "\n";
    }
}
