using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    vector<char> notes = {'A', 'B', 'C', 'D', 'E', 'F', 'G'};
    vector<char> keys(52);
    for (int i = 0; i < 52; ++i)
        keys[i] = notes[i % 7];

    map<char, vector<int>> positions;
    for (int i = 0; i < 52; ++i)
        positions[keys[i]].push_back(i);

    int t;
    cin >> t;
    while (t--) {
        string s;
        cin >> s;

        vector<int> possible = positions[s[0]];

        for (int i = 1; i < (int)s.size(); ++i) {
            vector<int> new_possible;
            for (int p : positions[s[i]]) {
                for (int q : possible) {
                    if (abs(p - q) <= 3) {
                        new_possible.push_back(p);
                        break;
                    }
                }
            }
            possible = move(new_possible);
            if (possible.empty()) break;
        }

        cout << (possible.empty() ? "NO" : "YES") << "\n";
    }

    return 0;
}

