#include <bits/stdc++.h>

using namespace std;

struct Coords {
    int x, y, z, val;
    bool operator==(const Coords& other) const {
        return x == other.x && y == other.y && z == other.z;
    }
};

namespace std {
    template<>
    struct hash<Coords> {
        size_t operator()(const Coords& c) const {
            size_t c1 = hash<int>{}(c.x);
            size_t c2 = hash<int>{}(c.y);
            size_t c3 = hash<int>{}(c.z);
            return c1 ^ (c2 << 1) ^ (c3 << 2);
        }
    };
}

vector<Coords> parse(int n) {
    vector<Coords> ans;
    ans.reserve(3 * n * n);
    cin.ignore();

    for (int r = 0; r < 2 * n - 1; ++r) {
        int z = r - (n - 1);
        int x_st = max(-(n - 1), -z - (n - 1));

        int num_items_in_row = (2 * n - 1) - abs(z);

        for (int col = 0; col < num_items_in_row; ++col) {
            int b;
            cin >> b;
            int x = x_st + col;
            int y = -x - z;
            ans.push_back({x, y, z, b});
        }
    }
    return ans;
}

void show_me_this_shit(const unordered_map<Coords, int>& res, int n) {
    for (int r = 0; r < 2 * n - 1; ++r) {
        int z = r - (n - 1);
        int ncol = (2 * n - 1) - abs(z);
        int x_st = max(-(n - 1), -z - (n - 1));
        for (int c = 0; c < ncol; ++c) {
            int x = x_st + c;
            int y = -x - z;
            Coords k = {x, y, z, 0};
            cout << res.at(k);
            if (c < ncol - 1) {
                cout << " ";
            }
        }
        cout << "\n";
    }
}

Coords r_k(const Coords& c, int k) {
    switch (k) {
        case 0: return {c.x, c.y, c.z, 0};
        case 1: return {-c.z, -c.x, -c.y, 0};
        case 2: return {c.y, c.z, c.x, 0};
        case 3: return {-c.x, -c.y, -c.z, 0};
        case 4: return {c.z, c.x, c.y, 0};
        case 5: return {-c.y, -c.z, -c.x, 0};
    }
    return {c.x, c.y, c.z, 0};
}

Coords t(const Coords& c, int n) {
    int ncol = (2 * n - 1) - abs(c.z);
    int xr = max(-(n - 1), -c.z - (n - 1));
    int current_col = c.x - xr;
    int new_col = (ncol - 1) - current_col;
    int xn = xr + new_col;
    int yn = -xn - c.z;
    return {xn, yn, c.z, 0};
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);

    int n;
    cin >> n;

    vector<Coords> init = parse(n);

    string s;
    cin >> s;

    int k = 0;
    bool flip = false;

    for (char op : s) {
        if (op == 'T') {
            flip = !flip;
        } else if (op == 'R') {
            k = (flip) ? (k + 5) % 6 : (k + 1) % 6;
        } else if (op == 'L') {
            k = (flip) ? (k + 1) % 6 : (k + 5) % 6;
        }
    }

    unordered_map<Coords, int> final_hx;
    final_hx.reserve(init.size());

    for (const auto& cell : init) {
        Coords res = r_k(cell, k);

        if (flip) {
            res = t(res, n);
        }

        final_hx[res] = cell.val;
    }

    show_me_this_shit(final_hx, n);

    return 0;
}