#include <bits/stdc++.h>

using namespace std;

struct Coords {
    int x, y, z;
    bool operator==(const Coords& other) const {
        return x == other.x && y == other.y && z == other.z;
    }
};

namespace std {
    template<>
    struct hash<Coords> {
        size_t operator()(const Coords& c) const {
            size_t c1 = hash<int>{}(c.x);
            size_t c2 = hash<int>{}(c.y);
            size_t c3 = hash<int>{}(c.z);
            return c1 ^ (c2 << 1) ^ (c3 << 2);
        }
    };
};

unordered_map<Coords, int> parse(int n) {
    unordered_map<Coords, int> ans;
    cin.ignore();

    for (int r = 0; r < 2 * n - 1; ++r) {
        int z = r - (n - 1);
        int x_st = max(-(n - 1), -z - (n - 1));
        string l;
        getline(cin, l);
        stringstream s(l);
        int b;
        int col = 0;
        while (s >> b) {
            int x = x_st + col;
            int y = -x - z;
            ans[{x, y, z}] = b;
            col++;
        }
    }
    return ans;
}

void show_me_this_shit(const unordered_map<Coords, int>& res, int n) {
    for (int r = 0; r < 2 * n - 1; ++r) {
        int z = r - (n - 1);
        int ncol = (2 * n - 1) - abs(z);
        int x_st = max(-(n - 1), -z - (n - 1));
        for (int c = 0; c < ncol; ++c) {
            int x = x_st + c;
            int y = -x - z;
            Coords k = {x, y, z};
            auto it = res.find(k);
            if (it != res.end()) {
                cout << it->second;
            } else {
                cout << "0";
            }
            if (c < ncol - 1) {
                cout << " ";
            }
        }
        cout << "\n";
    }
}

Coords r_k(const Coords& c, int k) {
    static const array<Coords(*)(const Coords&), 6> rotations = {
        [](const Coords& c) { return c; },  // 0°
        [](const Coords& c) { return Coords{-c.z, -c.x, -c.y}; },  // 60
        [](const Coords& c) { return Coords{c.y, c.z, c.x}; },  // 120
        [](const Coords& c) { return Coords{-c.x, -c.y, -c.z}; },  // 180
        [](const Coords& c) { return Coords{c.z, c.x, c.y}; },  // 240
        [](const Coords& c) { return Coords{-c.y, -c.z, -c.x}; }  // 300
    };
    return rotations[k](c);
}

Coords t(const Coords& c, int n) {
    int ncol = (2 * n - 1) - abs(c.z);
    int xr = max(-(n - 1), -c.z - (n - 1));
    int current_col = c.x - xr;
    int new_col = (ncol - 1) - current_col;
    int xn = xr + new_col;
    int yn = -xn - c.z;
    return {xn, yn, c.z};
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);

    int n;
    cin >> n;

    unordered_map<Coords, int> initial_hx = parse(n);

    string s;
    cin >> s;

    int k = 0;
    bool flip = false;

    for (char op : s) {
        if (op == 'T') {
            flip = !flip;  // свап
        } else if (op == 'R') {
            k = (flip) ? (k + 5) % 6 : (k + 1) % 6;
        } else if (op == 'L') {
            k = (flip) ? (k + 1) % 6 : (k + 5) % 6;  // против чс
        }
    }

    unordered_map<Coords, int> final_hx;
    final_hx.reserve(initial_hx.size());

    for (const auto& pair : initial_hx) {
        Coords res = r_k(pair.first, k);

        if (flip) {
            res = t(res, n);
        }

        final_hx[res] = pair.second;
    }

    show_me_this_shit(final_hx, n);

    return 0;
}