#include <bits/stdc++.h>

using namespace std;

struct Coords {
    int x, y, z;
    bool operator==(const Coords& other) const {
        return x == other.x && y == other.y && z == other.z;
    }
};

namespace std {
    template<>
    struct hash<Coords> {
        size_t operator()(const Coords& c) const {
            size_t c1 = hash<int>{}(c.x);
            size_t c2 = hash<int>{}(c.y);
            size_t c3 = hash<int>{}(c.z);
            return c1 ^ (c2 << 1) ^ (c3 << 2);
        }
    };
}

unordered_map<Coords, int> parse(int n) {
    unordered_map<Coords, int> ans;
    cin.ignore();
    for (int r = 0; r < 2 * n - 1; ++r) {
        int z = r - (n - 1);
        int x_st = max(-(n - 1), -z - (n - 1));
        string l;
        getline(cin, l);
        stringstream s(l);
        int b;
        int col = 0;
        while (s >> b) {
            int x = x_st + col;
            int y = -x - z;
            ans[{x, y, z}] = b;
            col++;
        }
    }
    return ans;
}

void show_me_this_shit(const unordered_map<Coords, int>& res, int n) {
    for (int r = 0; r < 2 * n - 1; ++r) {
        int z = r - (n - 1);
        int ncol = (2 * n - 1) - abs(z);
        int x_st = max(-(n - 1), -z - (n - 1));
        for (int c = 0; c < ncol; ++c) {
            int x = x_st + c;
            int y = -x - z;
            Coords k = {x, y, z};
            cout << res.at(k);
            if (c < ncol - 1) {
                cout << " ";
            }
        }
        cout << "\n";
    }
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;

    unordered_map<Coords, int>* curr_hx = new unordered_map<Coords, int>(parse(n));
    unordered_map<Coords, int>* n_hx = new unordered_map<Coords, int>();
    n_hx->reserve(curr_hx->size());

    string s;
    cin >> s;

    for (char op : s) {
        n_hx->clear();

        for (auto& pair : *curr_hx) {
            const Coords& oldc = pair.first;
            int value = pair.second;
            Coords newc;

            if (op == 'R') {
                newc = {-oldc.z, -oldc.x, -oldc.y};
            } else if (op == 'L') {
                newc = {-oldc.y, -oldc.z, -oldc.x};
            } else if (op == 'T') {
                int ncol = (2 * n - 1) - abs(oldc.z);
                int xr = max(-(n - 1), -oldc.z - (n - 1));

                int current_col = oldc.x - xr;
                int new_col = (ncol - 1) - current_col;

                int xn = xr + new_col;
                int yn = -xn - oldc.z;

                newc = {xn, yn, oldc.z};
            }

            (*n_hx)[newc] = value;
        }

        swap(curr_hx, n_hx);
    }

    show_me_this_shit(*curr_hx, n);

    return 0;
}