#include <bits/stdc++.h>

using namespace std;

vector<vector<int>> init(int n) {
    vector<vector<int>> v(2 * n - 1);
    int p = 0;
    for (int i = n; i <= 2 * n - 1; ++i) {
        v[p].resize(i);
        p++;
    }
    for (int i = 2 * n - 2; i >= n; --i) {
        v[p].resize(i);
        p++;
    }
    return v;
}

void print(const vector<vector<int>>& v) {
    for (const auto& x : v) {
        for (auto xx: x) cout << xx << ' ';
        cout << '\n';
    }
}

vector<vector<int>> opL(const vector<vector<int>>& v, int n) {
    auto res = init(n);
    int h = n - 1;
    vector<int> shifts(2 * n - 1);
    for (int i = 0; i < shifts.size(); ++i) shifts[i] = v[i].size() - 1;
    for (int i = 0; i < res.size(); ++i) {
        int r = max(0, i - h);
        for (int j = 0; j < res[i].size(); ++j) {
            res[i][j] = v[r + j][shifts[r + j]--];
        }
    }
    return res;
}

vector<vector<int>> opT(vector<vector<int>> v, int n) {
    for (int i = 0; i < v.size(); ++i) {
        auto last = v[i].size() - 1;
        for (int j = 0; j < v[i].size() / 2; ++j) {
            swap(v[i][j], v[i][last - j]);
        }
    }
    return v;
}

void solve() {
    int n;
    cin >> n;
    auto v = init(n);
    for (auto& x : v) {
        for (auto& xx : x) cin >> xx;
    }
    int plusL = 0;
    bool haveT = false;
    string ops;
    cin >> ops;
    for (auto c : ops) {
        if (c == 'L') {
            if (haveT) {
                --plusL;
            } else {
                ++plusL;
            }
        } else if (c == 'R') {
            if (haveT) {
                ++plusL;
            } else {
                --plusL;
            }
        } else {
            haveT ^= true;
        }
    }
    plusL %= 6;
    if (plusL < 0) plusL += 6;
    for (int i = 0; i < plusL; ++i) {
        v = opL(v, n);
    }
    if (haveT) {
        v = opT(std::move(v), n);
    }
    print(v);
}

int32_t main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);

    int t = 1;
    //cin >> t;
    while (t--) {
        solve();
    }

    return 0;
}
