﻿#include <iostream>
#include <vector>
#include <string>
#include <algorithm>

using namespace std;

vector<vector<int>> rot(const vector<vector<int>>& src, int n) {
    int size = 2 * n - 1;

    vector<int> min_q(size), max_q(size);
    for (int i = 0; i < size; i++)
    {
        int s = i - (n - 1);
        min_q[i] = max(-(n - 1), -s - (n - 1));
        max_q[i] = min(n - 1, -s + (n - 1));
    }

    vector<vector<int>> dst(size);
    for (int i = 0; i < size; i++)
    {
        int count = max_q[i] - min_q[i] + 1;
        dst[i].resize(count);
    }

    for (int i = 0; i < size; i++)
    {
        int s = i - (n - 1);
        for (int j = 0; j < src[i].size(); j++) {
            int q = min_q[i] + j;
            int r = -s - q;

            int q_new = -r;
            int r_new = q + r;
            int s_new = -q_new - r_new;

            int i_new = s_new + (n - 1);
            int j_new = q_new - min_q[i_new];

            dst[i_new][j_new] = src[i][j];
        }
    }

    return dst;
}

int main()
{
    int n;
    cin >> n;
    cin.ignore();
    vector<vector<int>> hex(2 * n - 1);
    for (int i = 0; i < 2 * n - 1; i++)
    {
        string line;
        getline(cin, line);
        vector<string> tokens;
        string token;
        for (char c : line)
        {
            if (c == ' ')
            {
                if (!token.empty())
                {
                    tokens.push_back(token);
                    token.clear();
                }
            }
            else token += c;

        }
        if (!token.empty()) tokens.push_back(token);

        for (const string& t : tokens) hex[i].push_back(stoi(t));

    }
    string op;
    getline(cin, op);
    int rotate=0,mnoj=1;
    for (int i = 0; i < op.length(); i++)
    {
        if (op[i] == 'L')
            rotate -= mnoj;
        if (op[i] == 'R')
            rotate += mnoj;
        if (op[i] == 'T')
            mnoj = -mnoj;
    }
    rotate %= 6;
    if (rotate < 0)
        rotate += 6;
    for (int i = 0; i < 6-rotate; i++) hex = rot(hex, n);
    for (int i = 0; i < 2 * n - 1; i++)
    {
        if (mnoj > 0)
        {
            for (int j = 0; j < hex[i].size(); j++)
            {
                if (j > 0)
                {
                    cout << " ";
                }
                cout << hex[i][j];
            }
        }
        else for (int j = hex[i].size()-1; j >=0; j--) cout << hex[i][j]<<" ";

        cout << endl;
    }

    return 0;
}
