#include <bits/stdc++.h>

using namespace std;

typedef long long ll;
const int MAX = 2000010;
const ll MOD = 1000000007LL;

ll fact[MAX];
ll invfact[MAX];

ll modpow(ll base, ll exp) {
    ll res = 1;
    while (exp) {
        if (exp & 1) res = res * base % MOD;
        base = base * base % MOD;
        exp >>= 1;
    }
    return res;
}

void precompute() {
    fact[0] = 1;
    for (int i = 1; i < MAX; ++i) {
        fact[i] = fact[i - 1] * i % MOD;
    }
    invfact[MAX - 1] = modpow(fact[MAX - 1], MOD - 2);
    for (int i = MAX - 2; i >= 0; --i) {
        invfact[i] = invfact[i + 1] * (i + 1) % MOD;
    }
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(NULL);
    precompute();
    int t;
    cin >> t;
    for (int test = 0; test < t; ++test) {
        int p, m;
        cin >> p >> m;
        int N = 2 * p + m;
        ll num = (2LL * p + m + 1) % MOD;
        ll inv_odd = modpow(2LL * p + 1, MOD - 2);
        ll pow2 = modpow(2, 2LL * p);
        ll inv_c = invfact[2 * p] * fact[p] % MOD * fact[p] % MOD;
        ll ans = num * inv_odd % MOD * pow2 % MOD * inv_c % MOD;
        cout << ans << "\n";
    }
    return 0;
}