﻿#include <algorithm>
#include <iostream>
#include <vector>
#define vec vector
#define umap unordered_map
using namespace std;

#define ll long long
#define ull unsigned long long
#define MOD (ull)(1e9 + 7)

ll mod2(ll base, ll exp, ll mod) {
    ll result = 1;
    while (exp > 0) {
        if (exp % 2 == 1) {
            result = (result * base) % mod;
        }
        base = (base * base) % mod;
        exp /= 2;
    }
    return result;
}

ll inv(ll a, ll mod) {
    return mod2(a, mod - 2, mod);
}
    
int main() {
    int max_n = 2000005;

    vec<ll> f(max_n);
    vec<ll> nf(max_n);
    vec<ll> p4(max_n);

    f[0] = 1;
    for (int i = 1; i < max_n; i++) {
        f[i] = (f[i - 1] * i) % MOD;
    }

    nf[max_n -1 ] = inv(f[max_n-1], MOD);
    for (int i = max_n - 2; i >= 0; i--) {
        nf[i] = nf[i + 1] * (i + 1) % MOD;
    }

    p4[0] = 1;
    for (int p = 1; p < max_n; p++) {
        p4[p] = p4[p - 1] * 4 % MOD;
    }

    int t;
    cin >> t;
    while (t--) {
        int p, m;
        cin >> p >> m;
        ll x = ((2 * p + 1) % MOD * f[2 * p] % MOD * nf[p] % MOD * nf[p] % MOD) % MOD ;
        ll x2 = ((2 * p + m + 1) % MOD * p4[p] % MOD) % MOD;
        if (x % x2 != 0) {
            ll ans = (x2 % MOD * inv(x, MOD)) % MOD;
            cout << ans << '\n';
        }
        else {
            cout << x / x2 << '\n';
        }
    }

    return 0;
}