#include <bits/stdc++.h>
using namespace std;

const int MOD = 1e9 + 7;
const int MAX_N = 3000005;

long long fac[MAX_N], inv_fac[MAX_N];

long long binpow(long long a, long long n) {
    long long res = 1;
    while (n) {
        if (n & 1) res = res * a % MOD;
        a = a * a % MOD;
        n >>= 1;
    }
    return res;
}

long long nCr(int n, int r) {
    if (r < 0 || r > n) return 0;
    return fac[n] * inv_fac[r] % MOD * inv_fac[n - r] % MOD;
}

void solve() {
    int p, m;
    cin >> p >> m;
    int n = 2 * p + m;

    long long total = 1;
    long long product = 1;

    for (int i = 1; i <= p; i++) {
        long long num = 2 * (p - i + 1) % MOD;
        long long den = n - i + 1;
        product = product * num % MOD;
        product = product * binpow(den, MOD - 2) % MOD;

        total = (total + product * binpow(i, MOD - 2)) % MOD;
    }

    cout << total << '\n';
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);

    fac[0] = 1;
    for (int i = 1; i < MAX_N; i++) {
        fac[i] = fac[i - 1] * i % MOD;
    }
    inv_fac[MAX_N - 1] = binpow(fac[MAX_N - 1], MOD - 2);
    for (int i = MAX_N - 2; i >= 0; i--) {
        inv_fac[i] = inv_fac[i + 1] * (i + 1) % MOD;
    }

    int t;
    cin >> t;
    while (t--) {
        solve();
    }

    return 0;
}