#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

using int64 = long long;
const int64 MOD = 1'000'000'007;

int64 modpow(int64 a, int64 e) {
    int64 r = 1 % MOD;
    a %= MOD;
    while (e) {
        if (e & 1) r = (r * a) % MOD;
        a = (a * a) % MOD;
        e >>= 1;
    }
    return r;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int T; 
    if (!(cin >> T)) return 0;
    vector<pair<int,int>> q(T);
    int maxP = 1;
    for (int i = 0; i < T; ++i) {
        int p, m; cin >> p >> m;
        q[i] = {p, m};
        maxP = max(maxP, p);
    }

    int MAXF = 2 * maxP + 1;
    vector<int64> fact(MAXF + 1), invfact(MAXF + 1), pow2(maxP + 1);
    fact[0] = 1;
    for (int i = 1; i <= MAXF; ++i) fact[i] = fact[i-1] * i % MOD;
    invfact[MAXF] = modpow(fact[MAXF], MOD - 2);
    for (int i = MAXF; i > 0; --i) invfact[i-1] = invfact[i] * i % MOD;

    pow2[0] = 1;
    for (int i = 1; i <= maxP; ++i) pow2[i] = (pow2[i-1] * 2) % MOD;

    auto S = [&](int k) -> int64 {
        int64 a = pow2[k] * fact[k] % MOD;
        int64 num = a * a % MOD;
        int idx = 2*k + 1;
        return num * invfact[idx] % MOD;
    };

    for (auto [p, m] : q) {
        int64 term1 = (2LL * p) % MOD * S(p - 1) % MOD;
        int64 term2 = (int64)m % MOD * S(p) % MOD;
        int64 ans = (term1 + term2) % MOD;
        cout << ans << '\n';
    }
    return 0;
}
