#include <iostream>
#include <vector>
#include <cstdint>
using namespace std;

static const int P = 999983;
static const uint64_t ONE = 1ULL;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    const uint64_t Acoef = 618023;
    const uint64_t C = 1;

    int n, s;
    if (!(cin >> n >> s)) return 0;

    const int W = (P + 63) >> 6;          
    vector<uint64_t> A(W + 1, 0);         
    vector<uint64_t> F(W + 1, 0);         

    auto get_bit = [&](const vector<uint64_t>& B, int i) -> int {
        return (B[i >> 6] >> (i & 63)) & 1ULL;
    };
    
    auto set_bit1 = [&](vector<uint64_t>& B, int i) {
        B[i >> 6] |= (ONE << (i & 63));
    };

    auto xor_segment_shifted = [&](size_t src, size_t dst, size_t len) {
        if (len == 0) return;

        size_t s = src, d = dst, rem = len;

        while (rem) {
            size_t sw = s >> 6; 
            unsigned soff = s & 63;
            uint64_t chunk = A[sw] >> soff;
            if (soff && sw + 1 < A.size()) {
                chunk |= (A[sw + 1] << (64 - soff));
            }

            unsigned take = (rem >= 64 ? 64u : (unsigned)rem);
            if (take < 64) {
                chunk &= ((ONE << take) - 1ULL);
            }

            size_t dw = d >> 6; 
            unsigned doff = d & 63;
            if (doff == 0) {
                F[dw] ^= chunk;
            } else {
                F[dw]     ^= (chunk << doff);
                F[dw + 1] ^= (chunk >> (64 - doff));
            }

            s += take; 
            d += take; 
            rem -= take;
        }
    };

    int inserted = 0;

    for (int step = 0; step < n; ++step) {
        s = int(((uint64_t)s * Acoef + C) % P);

        int parity = get_bit(F, s);

        if (parity == 0 && get_bit(A, s) == 0) {
            set_bit1(A, s);
            ++inserted;

            if (2LL * s < P) {
                size_t src = (size_t)s;
                size_t dst = (size_t)(2 * s);
                size_t len = (size_t)(P - 2 * s);
                xor_segment_shifted(src, dst, len);
            }
        }
    }

    cout << inserted << '\n';
    return 0;
}

