#include <iostream>
#include <vector>
#include <complex>
#include <cmath>
#include <algorithm>

using namespace std;

const int MOD = 999983;

using Complex = complex<double>;
const double PI = acos(-1.0);

void fft(vector<Complex>& a, bool invert) {
    int n = a.size();
    if (n <= 1) return;

    vector<Complex> a0(n / 2), a1(n / 2);
    for (int i = 0; 2 * i < n; i++) {
        a0[i] = a[2 * i];
        a1[i] = a[2 * i + 1];
    }
    fft(a0, invert);
    fft(a1, invert);

    double ang = 2 * PI / n * (invert ? -1 : 1);
    Complex w(1), wn(cos(ang), sin(ang));
    for (int i = 0; 2 * i < n; i++) {
        a[i] = a0[i] + w * a1[i];
        a[i + n / 2] = a0[i] - w * a1[i];
        w *= wn;
    }

    if (invert) {
        for (auto& x : a) {
            x /= 2;
        }
    }
}

vector<long long> multiply(const vector<bool>& p1, const vector<bool>& p2) {
    vector<Complex> fa(p1.begin(), p1.end()), fb(p2.begin(), p2.end());
    int n = 1;
    while (n < p1.size() + p2.size()) {
        n <<= 1;
    }
    fa.resize(n);
    fb.resize(n);

    fft(fa, false);
    fft(fb, false);
    for (int i = 0; i < n; i++) {
        fa[i] *= fb[i];
    }
    fft(fa, true);

    vector<long long> result(n);
    for (int i = 0; i < n; i++) {
        result[i] = round(fa[i].real());
    }
    return result;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);

    int n;
    long long s;
    cin >> n >> s;

    vector<bool> in_V(MOD, false);
    vector<long long> smc(2 * MOD, 0);

    vector<int> v_block;

    int block_size = 600;

    for (int i = 0; i < n; i++) {
        if (i > 0 && i % block_size == 0) {
            if (!v_block.empty()) {
                vector<bool> p_main(MOD, false);
                vector<bool> p_block(MOD, false);
                for(int val : v_block) p_block[val] = true;
                for(int j=0; j<MOD; j++) if(in_V[j] && !p_block[j]) p_main[j] = true;
                vector<long long> cm_block = multiply(p_main, p_block);
                vector<long long> cb_block = multiply(p_block, p_block);
                for(size_t j=0; j<cm_block.size(); j++) smc[j] += 2 * cm_block[j];
                for(size_t j=0; j<cb_block.size(); j++) smc[j] += cb_block[j];
                v_block.clear();
            }
        }

        s = (s * 618023LL + 1) % MOD;
        int cs = s;

        long long pairs = 0;

        if (cs < smc.size()) {
            pairs += smc[cs];
        }
        vector<bool> iV(MOD, false);
        for(int val : v_block) iV[val] = true;

        for (int a : v_block) {
            int b = cs - a;
            if (b >= 0 && b < MOD) {
                if (in_V[b] && !iV[b]) {
                    pairs += 2;
                }
                if (iV[b]) {
                    pairs++;
                }
            }
        }
        long long ihalf = 0;
        if (cs % 2 == 0) {
            if (in_V[cs / 2]) {
                 ihalf = 1;
            }
        }
        long long total_pairs = (pairs + ihalf) / 2;

        if (total_pairs % 2 == 0) {
            if (!in_V[cs]) {
                in_V[cs] = true;
                v_block.push_back(cs);
            }
        }
    }
    int final_size = 0;
    for (int i = 0; i < MOD; i++) {
        if (in_V[i]) {
            final_size++;
        }
    }
    cout << final_size << endl;
}