MOD = 10**9 + 7

def modpow(a, e):
    res = 1
    while e:
        if e & 1:
            res = res * a % MOD
        a = a * a % MOD
        e >>= 1
    return res

def precompute_factorials(n):
    fact = [1] * (n + 1)
    inv_fact = [1] * (n + 1)
    for i in range(1, n + 1):
        fact[i] = fact[i - 1] * i % MOD
    inv_fact[n] = modpow(fact[n], MOD - 2)
    for i in range(n, 0, -1):
        inv_fact[i - 1] = inv_fact[i] * i % MOD
    return fact, inv_fact

def C(n, k, fact, inv_fact):
    if k < 0 or k > n:
        return 0
    return fact[n] * inv_fact[k] % MOD * inv_fact[n - k] % MOD

import sys
input = sys.stdin.readline
t = int(input())
data = [tuple(map(int, input().split())) for _ in range(t)]
maxN = max(2 * p + m for p, m in data)

fact, inv_fact = precompute_factorials(maxN)
pow2 = [1] * (maxN + 1)
for i in range(1, maxN + 1):
    pow2[i] = pow2[i - 1] * 2 % MOD

for p, m in data:
    N = 2 * p + m
    ans = 0
    for k in range(N):
        smin = max(0, k - m)
        smax = min(k, p)
        numer = 0
        for s in range(smin, smax + 1):
            term = C(p, s, fact, inv_fact) * pow2[s] % MOD
            term = term * C(m, k - s, fact, inv_fact) % MOD
            numer = (numer + term) % MOD
        denom = C(N, k, fact, inv_fact)
        Sk = numer * modpow(denom, MOD - 2) % MOD
        ans = (ans + Sk) % MOD
    print(ans)