keyboard = "ABCDEFGABCDEFGABCDEFGABCDEFGABCDEFGABCDEFGABCDEFGABC"
neighbor_masks = [0] * 52
for i in range(52):
    mask = 0
    for j in range(max(0, i-3), min(52, i+4)):
        mask |= (1 << j)
    neighbor_masks[i] = mask

note_masks = {}
for idx, note in enumerate(keyboard):
    note_masks.setdefault(note, 0)
    note_masks[note] |= (1 << idx)

t = int(input())
for _ in range(t):
    s = input().strip()
    reachable = note_masks[s[0]]
    
    possible = True
    for ch in s[1:]:
        new_reachable = 0
        note_mask = note_masks[ch]
        j = 0
        temp = note_mask
        while temp:
            if temp & 1:
                if reachable & neighbor_masks[j]:
                    new_reachable |= (1 << j)
            temp >>= 1
            j += 1
        
        reachable = new_reachable
        if not reachable:
            possible = False
            break
    
    print("Yes" if possible else "No")