#include <bits/stdc++.h>
 
using namespace std;
 
typedef long long ll;
typedef pair<int, int> pii;
typedef vector<int> vi;
 
#define forn(i, n) for (int (i) = 0; (i) != (n); (i)++)
#define all(x) (x).begin(), (x).end()

const int NN = 10e7;
const int INF = 1e9;

int dist[NN];
ll pdist[NN];
int init;

int digits(int x) {
    int res = 0;
    while (x) {
        res++;
        x /= 10;
    }
    return res;
}

void dfs(int x) {
    if (x == 1 || dist[x]) return;
    int colx = x % 2 == 0 ? x / 2 : 3 * x + 1;
    if (colx > NN) {
        dist[x] = INF;
        return;
    }
    dfs(colx);
    dist[x] = min(dist[colx] + digits(colx), INF);
}

void solve()
{
    if (!init) {
        for (int i = 2; i < NN; i++) {
            if (dist[i] == 0) {
                dfs(i);
            }
        }
        for (int i = 2; i < NN; i++) {
            pdist[i] = pdist[i - 1] + dist[i];
        }
        init = 1;
        int cnt_bad = 0;
        for (int j = 2; j < 1e7; j++) {
            if (dist[j] == INF) {
                cnt_bad++;
            }
        }
    }

    #define tests

    long long x;
    cin >> x;
    while (true) {
        if (6 * x < NN) {
            int coll = dist[x];
            double rnd = 1.0 * (pdist[6 * x] - pdist[3 * x]) / (3 * x);
            if (x % 2 == 0) coll = 0;
            // cout << setprecision(20) << coll << " " << rnd << endl;
            if (coll < rnd) {
                cout << "Collatz" << endl;
            } else {
                cout << "Random" << endl;
            }
        } else {
            cout << "Collatz" << endl;
        }
        cin >> x;
        if (x == 1) {
            break;
        }
        if (x == 0) {
            exit(0);
        }
    }
}
 
int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(0);

    int t = 1;
    #ifdef tests
    cin >> t;
    #endif // tests
 
    while (t--) {
        solve();
    }
}