#include <bits/stdc++.h>
#pragma GCC optimize("Ofast,unroll-loops")
//#pragma GCC target("avx2,sse")
  
using namespace std;
  
typedef unsigned long long ull;
typedef long long ll;
typedef double ld;
  
ll len(ll x) {
    ll s = 0;
    while (x) {
        s++;
        x /= 10;
    }
    return s;
}
  
ll collatz(ll x) {
    if (x % 2 == 0) return x / 2;
    else return 3 * x + 1;
}
  
const int N = (int) (1e7) + 3;
  
ll prec[N];
  
ll score(ll x) {
    ll me = x;
    ll sum = 0;
    ll y = 1;
    while (x != 1) {
        if (x < me) {
            sum += prec[x];
            break;
        }
        assert(x <= 1e17);
        x = collatz(x);
        sum += len(x);
    }
    return prec[me] = sum;
}
  
  
constexpr int digits(int base) noexcept {
    return base <= 1 ? 0 : 1 + digits(base / 10);
}
  
constexpr int base = 1000000000;
constexpr int base_digits = digits(base);
  
constexpr int fft_base = 10000;  // fft_base^2 * n / fft_base_digits <= 10^15 for double
constexpr int fft_base_digits = digits(fft_base);
  
struct bigint {
    // value == 0 is represented by empty z
    vector<int> z;  // digits
  
    // sign == 1 <==> value >= 0
    // sign == -1 <==> value < 0
    int sign;
  
    bigint(long long v = 0) { *this = v; }
  
    bigint &operator=(long long v) {
        sign = v < 0 ? -1 : 1;
        v *= sign;
        z.clear();
        for (; v > 0; v = v / base)
            z.push_back((int)(v % base));
        return *this;
    }
  
    bigint(const string &s) { read(s); }
  
    bigint &operator+=(const bigint &other) {
        if (sign == other.sign) {
            for (int i = 0, carry = 0; i < other.z.size() || carry; ++i) {
                if (i == z.size())
                    z.push_back(0);
                z[i] += carry + (i < other.z.size() ? other.z[i] : 0);
                carry = z[i] >= base;
                if (carry)
                    z[i] -= base;
            }
        } else if (other != 0 /* prevent infinite loop */) {
            *this -= -other;
        }
        return *this;
    }
  
    friend bigint operator+(bigint a, const bigint &b) {
        a += b;
        return a;
    }
  
    bigint &operator-=(const bigint &other) {
        if (sign == other.sign) {
            if ((sign == 1 && *this >= other) || (sign == -1 && *this <= other)) {
                for (int i = 0, carry = 0; i < other.z.size() || carry; ++i) {
                    z[i] -= carry + (i < other.z.size() ? other.z[i] : 0);
                    carry = z[i] < 0;
                    if (carry)
                        z[i] += base;
                }
                trim();
            } else {
                *this = other - *this;
                this->sign = -this->sign;
            }
        } else {
            *this += -other;
        }
        return *this;
    }
  
    friend bigint operator-(bigint a, const bigint &b) {
        a -= b;
        return a;
    }
  
    bigint &operator*=(int v) {
        if (v < 0)
            sign = -sign, v = -v;
        for (int i = 0, carry = 0; i < z.size() || carry; ++i) {
            if (i == z.size())
                z.push_back(0);
            long long cur = (long long)z[i] * v + carry;
            carry = (int)(cur / base);
            z[i] = (int)(cur % base);
        }
        trim();
        return *this;
    }
  
    bigint operator*(int v) const { return bigint(*this) *= v; }
  
    friend pair<bigint, bigint> divmod(const bigint &a1, const bigint &b1) {
        int norm = base / (b1.z.back() + 1);
        bigint a = a1.abs() * norm;
        bigint b = b1.abs() * norm;
        bigint q, r;
        q.z.resize(a.z.size());
  
        for (int i = (int)a.z.size() - 1; i >= 0; i--) {
            r *= base;
            r += a.z[i];
            int s1 = b.z.size() < r.z.size() ? r.z[b.z.size()] : 0;
            int s2 = b.z.size() - 1 < r.z.size() ? r.z[b.z.size() - 1] : 0;
            int d = (int)(((long long)s1 * base + s2) / b.z.back());
            r -= b * d;
            while (r < 0)
                r += b, --d;
            q.z[i] = d;
        }
  
        q.sign = a1.sign * b1.sign;
        r.sign = a1.sign;
        q.trim();
        r.trim();
        return {q, r / norm};
    }
  
    friend bigint sqrt(const bigint &a1) {
        bigint a = a1;
        while (a.z.empty() || a.z.size() % 2 == 1)
            a.z.push_back(0);
  
        int n = a.z.size();
  
        int firstDigit = (int)::sqrt((double)a.z[n - 1] * base + a.z[n - 2]);
        int norm = base / (firstDigit + 1);
        a *= norm;
        a *= norm;
        while (a.z.empty() || a.z.size() % 2 == 1)
            a.z.push_back(0);
  
        bigint r = (long long)a.z[n - 1] * base + a.z[n - 2];
        firstDigit = (int)::sqrt((double)a.z[n - 1] * base + a.z[n - 2]);
        int q = firstDigit;
        bigint res;
  
        for (int j = n / 2 - 1; j >= 0; j--) {
            for (;; --q) {
                bigint r1 = (r - (res * 2 * base + q) * q) * base * base +
                            (j > 0 ? (long long)a.z[2 * j - 1] * base + a.z[2 * j - 2] : 0);
                if (r1 >= 0) {
                    r = r1;
                    break;
                }
            }
            res *= base;
            res += q;
  
            if (j > 0) {
                int d1 = res.z.size() + 2 < r.z.size() ? r.z[res.z.size() + 2] : 0;
                int d2 = res.z.size() + 1 < r.z.size() ? r.z[res.z.size() + 1] : 0;
                int d3 = res.z.size() < r.z.size() ? r.z[res.z.size()] : 0;
                q = (int)(((long long)d1 * base * base + (long long)d2 * base + d3) / (firstDigit * 2));
            }
        }
  
        res.trim();
        return res / norm;
    }
  
    bigint operator/(const bigint &v) const { return divmod(*this, v).first; }
  
    bigint operator%(const bigint &v) const { return divmod(*this, v).second; }
  
    bigint &operator/=(int v) {
        if (v < 0)
            sign = -sign, v = -v;
        for (int i = (int)z.size() - 1, rem = 0; i >= 0; --i) {
            long long cur = z[i] + rem * (long long)base;
            z[i] = (int)(cur / v);
            rem = (int)(cur % v);
        }
        trim();
        return *this;
    }
  
    bigint operator/(int v) const { return bigint(*this) /= v; }
  
    int operator%(int v) const {
        if (v < 0)
            v = -v;
        int m = 0;
        for (int i = (int)z.size() - 1; i >= 0; --i)
            m = (int)((z[i] + m * (long long)base) % v);
        return m * sign;
    }
  
    bigint &operator*=(const bigint &v) {
        *this = *this * v;
        return *this;
    }
  
    bigint &operator/=(const bigint &v) {
        *this = *this / v;
        return *this;
    }
  
    bigint &operator%=(const bigint &v) {
        *this = *this % v;
        return *this;
    }
  
    bool operator<(const bigint &v) const {
        if (sign != v.sign)
            return sign < v.sign;
        if (z.size() != v.z.size())
            return z.size() * sign < v.z.size() * v.sign;
        for (int i = (int)z.size() - 1; i >= 0; i--)
            if (z[i] != v.z[i])
                return z[i] * sign < v.z[i] * sign;
        return false;
    }
  
    bool operator>(const bigint &v) const { return v < *this; }
  
    bool operator<=(const bigint &v) const { return !(v < *this); }
  
    bool operator>=(const bigint &v) const { return !(*this < v); }
  
    bool operator==(const bigint &v) const { return sign == v.sign && z == v.z; }
  
    bool operator!=(const bigint &v) const { return !(*this == v); }
  
    void trim() {
        while (!z.empty() && z.back() == 0)
            z.pop_back();
        if (z.empty())
            sign = 1;
    }
  
    bool isZero() const { return z.empty(); }
  
    friend bigint operator-(bigint v) {
        if (!v.z.empty())
            v.sign = -v.sign;
        return v;
    }
  
    bigint abs() const { return sign == 1 ? *this : -*this; }
  
    long long longValue() const {
        long long res = 0;
        for (int i = (int)z.size() - 1; i >= 0; i--)
            res = res * base + z[i];
        return res * sign;
    }
  
    friend bigint gcd(const bigint &a, const bigint &b) { return b.isZero() ? a : gcd(b, a % b); }
  
    friend bigint lcm(const bigint &a, const bigint &b) { return a / gcd(a, b) * b; }
  
    void read(const string &s) {
        sign = 1;
        z.clear();
        int pos = 0;
        while (pos < s.size() && (s[pos] == '-' || s[pos] == '+')) {
            if (s[pos] == '-')
                sign = -sign;
            ++pos;
        }
        for (int i = (int)s.size() - 1; i >= pos; i -= base_digits) {
            int x = 0;
            for (int j = max(pos, i - base_digits + 1); j <= i; j++)
                x = x * 10 + s[j] - '0';
            z.push_back(x);
        }
        trim();
    }
  
    friend istream &operator>>(istream &stream, bigint &v) {
        string s;
        stream >> s;
        v.read(s);
        return stream;
    }
  
    friend ostream &operator<<(ostream &stream, const bigint &v) {
        if (v.sign == -1)
            stream << '-';
        stream << (v.z.empty() ? 0 : v.z.back());
        for (int i = (int)v.z.size() - 2; i >= 0; --i)
            stream << setw(base_digits) << setfill('0') << v.z[i];
        return stream;
    }
  
    static vector<int> convert_base(const vector<int> &a, int old_digits, int new_digits) {
        vector<long long> p(max(old_digits, new_digits) + 1);
        p[0] = 1;
        for (int i = 1; i < p.size(); i++)
            p[i] = p[i - 1] * 10;
        vector<int> res;
        long long cur = 0;
        int cur_digits = 0;
        for (int v : a) {
            cur += v * p[cur_digits];
            cur_digits += old_digits;
            while (cur_digits >= new_digits) {
                res.push_back(int(cur % p[new_digits]));
                cur /= p[new_digits];
                cur_digits -= new_digits;
            }
        }
        res.push_back((int)cur);
        while (!res.empty() && res.back() == 0)
            res.pop_back();
        return res;
    }
  
    bigint operator*(const bigint &v) const {
          return mul_simple(v);
          /*
        bigint res;
        res.sign = sign * v.sign;
        res.z = multiply_bigint(convert_base(z, base_digits, fft_base_digits),
                                convert_base(v.z, base_digits, fft_base_digits), fft_base);
        res.z = convert_base(res.z, fft_base_digits, base_digits);
        res.trim();
        return res;
        */
    }
  
    bigint mul_simple(const bigint &v) const {
        bigint res;
        res.sign = sign * v.sign;
        res.z.resize(z.size() + v.z.size());
        for (int i = 0; i < z.size(); ++i)
            if (z[i])
                for (int j = 0, carry = 0; j < v.z.size() || carry; ++j) {
                    long long cur = res.z[i + j] + (long long)z[i] * (j < v.z.size() ? v.z[j] : 0) + carry;
                    carry = (int)(cur / base);
                    res.z[i + j] = (int)(cur % base);
                }
        res.trim();
        return res;
    }
};
  
int get_len(bigint p) {
    int sum = 0;
    while (p != 0) {
        sum++;
        p /= 10;
    }
    return sum;
}
  
int collatz_score(bigint p) {
    int sum = 0;
    while (p != 1) {
        p = (p % 2 == 0 ? p / 2 : (p * 3)+ 1);
        sum += get_len(p);
    }
    return sum;
}
  
bigint sample(bigint l, bigint r) {
    int x = rand() % (100000);
    if (l + x > r) return ((l + r) / 2);
    if (rand() % 2) {
        return l + x;
    } else {
        return r - x;
    }
}
 
int flag = -1;
int cnt = 0;
 
 bigint cur[12345];
bigint vg[12345];

int solve(bigint p) {
    bigint x = 1;
    int cnt = 1;
    while (x <= p) {
        x *= 3;
        cnt++;
    }
    if (vg[cnt] * 7 / 6 + get_len(p * 6) < collatz_score(p)) {
        return 0;
    } else {
        return 1;
    }
    if (flag != -1) return flag;
    while (p != 1) {
        int sum = 0;
        bigint avg = 0;
        for (int it = 0; it < 100; it++) {
            bigint cur = sample((p * 3) + 1, (p * 6));
            avg += cur;
            sum += collatz_score(cur);
        }
        avg = avg / 100;
        sum /= 100;
        if (sum + get_len(p * 6) < collatz_score(p)) {
            flag = 1;
            return 0;
        } else {
            return flag = 1;
        }
    }
    return -1;
}
  

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    mt19937 rnd(233);
    // freopen("a.in", "r", stdin);
    #ifdef ONPC
        //freopen("a.in", "r", stdin);
    #endif
    bigint prev = 1;
    bigint i = 1, j = 3;
    ll l = 1, r = 3;
    for (int steps = 0; steps < 100; steps++) {
    
        if (j < 10000) {
             bigint sum = 0;
            for (int x = (ll) l; x < (ll) r; x++) {
                sum += collatz_score(x);
            }
            cur[steps] = sum;
        } else {
            cur[steps] = cur[steps - 1] * 7 / 2;
        }
        vg[steps] = cur[steps] / (j - i);
        i *= 3;
        l *= 3;
        r *= 3;
        j *= 3;
    }
    int t = 50;
    cin >> t;
    while (t--) {
        flag = -1;
        bigint x;
        cin >> x;
        while (true) {
            bool a = false;
            if (solve(x) == 0) {
                cout << "random" << endl;
            } else {
                cout << "collatz" << endl;
            }
            bigint y;
            cin >> y;
            if (y == 0) assert(0);
            if (y == 1) break;
            x = y;
        }
    }
    return 0;
    
  
}