// #pragma GCC optimize("Ofast,unroll-loops")
#include <bits/stdc++.h>
// #pragma GCC target("avx2,sse")
using namespace std;
#define int long long
using ll = long long;

struct pt {
    int x, y;

    friend pt operator-(const pt &a, const pt &b) {
        return {a.x - b.x, a.y - b.y};
    }

    friend pt operator+(const pt &a, const pt &b) {
        return {a.x + b.x, a.y + b.y};
    }

    int norm2() const {
        return x * x + y * y;
    }

    pt perp() const {
        return {-y, x};
    }
};

int cross(pt a, pt b) {
    return a.x * b.y - a.y * b.x;
}

array<int, 3> get_ABC(pt a, pt b) {
    pt v = (a - b).perp();
    int A = v.x, B = v.y;
    int C = -(A * a.x + B * a.y);
    return {A, B, C};
}

int sq(int x) {
    return x * x;
}

pair<int, int> get_dist(pt p, int A, int B, int C) {
    assert(A*A+B*B>0);
    return {sq(p.x * A + p.y * B + C), A * A + B * B};
}

int sign(int x) {
    return (x > 0) - (x < 0);
}

void solve() {
    int n;
    cin >> n;
    vector<pt> a(n);
    for (auto& [x, y] : a) cin >> x >> y;
    int pos = 0;
    for (int i = 1; i < n; ++i) {
        if (a[i].y < a[pos].y || a[i].y == a[pos].y && a[i].x < a[pos].x)
            pos = i;
    }
    pt O = a[pos];
    a.erase(a.begin() + pos);
    sort(a.begin(), a.end(), [&](pt a, pt b) {
        if (cross(a - O, b - O) == 0)
            return (a - O).norm2() < (b - O).norm2();
        return cross(a - O, b - O) > 0;
    });
    vector<pt> hp{O};
    for (auto& p : a) {
        while (hp.size() >= 2 && cross(hp.back() - hp[hp.size() - 2], p - hp.back()) <= 0) {
            hp.pop_back();
        }
        hp.push_back(p);
    }
    a.push_back(O);
    int A1 = -1, B1 = -1, C1 = -1;
    int A2 = -1, B2 = -1, C2 = -1;
    int up = -1, down = -1;
    int sz = hp.size();
    for (int i = 0; i < sz; ++i) {
        auto [AA1, BB1, CC1] = get_ABC(hp[i], hp[(i + 1) % sz]);
        int AA2 = AA1, BB2 = BB1, CC2 = CC1;
        int cur_up = 0, cur_down = 1;
        for (int j = 0; j < n; ++j) {
            auto [upp, downn] = get_dist(a[j], AA1, BB1, CC1);
            if ((__int128)cur_up * downn < (__int128)upp * cur_down) {
                cur_up = upp, cur_down = downn;
                auto [q, w, e] = get_ABC(a[j], a[j] + (hp[i] - hp[(i + 1) % sz]));
                AA2 = q, BB2 = w, CC2 = e;
            }
        }
        if (up == -1 || (__int128)up * cur_down < (__int128)down * cur_up) {
            up = cur_up;
            down = cur_down;
            A1 = AA1, B1 = BB1, C1 = CC1;
            A2 = AA2, B2 = BB2, C2 = CC2;
        }
    }
    for (int i = 0; i < sz; ++i) {
        for (int j = i + 1; j < sz; ++j) {
            pt v = (hp[i] - hp[j]).perp();
            if (sign(cross(v, hp[(i-1+sz)%sz] - hp[i])) * sign(cross(v, hp[(i+1)%sz] - hp[i])) >= 0) {
                if (sign(cross(v, hp[(j-1+sz)%sz] - hp[j])) * sign(cross(v, hp[(j+1)%sz] - hp[j])) >= 0) {
                    auto [AA1, BB1, CC1] = get_ABC(hp[i], hp[i] + v);
                    auto [AA2, BB2, CC2] = get_ABC(hp[j], hp[j] + v);
                    auto [upp, downn] = get_dist(hp[j], AA1, BB1, CC1);
                    if (up == -1 || (__int128)up * downn < (__int128)upp * down) {
                        up = upp, down = downn;
                        A1 = AA1, B1 = BB1, C1 = CC1;
                        A2 = AA1, B2 = BB2, C2 = CC2;
                    }
                }
            }
        }
    }
    assert(abs(A1)<=1e9);
    assert(abs(A2)<=1e9);
    assert(abs(B1)<=1e9);
    assert(abs(B2)<=1e9);
    assert(abs(C1)<=1e9);
    assert(abs(C2)<=1e9);
    cout << A1 << " " << B1 << " " << C1 << "\n";
    cout << A2 << " " << B2 << " " << C2 << "\n";
}

int32_t main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.precision(10);

    // freopen("input.txt", "r", stdin);
    // freopen("output.txt", "w", stdout);

    int T = 1;
    while (T--)
        solve();

    return 0;
}
