#include <iostream>
#include <vector>
#include <cmath>
#include <iomanip>
#define USE_MATH_DEFINES

using namespace std;

typedef long long ll;
typedef long double ld;

const ll mod = 2286661337;

ll bin_pow(ll a, ll n) {
    if (n == 0) {
        return 1;
    } else if (n % 2 == 1) {
        return a * bin_pow(a, n - 1) % mod;
    } else {
        ll b = bin_pow(a, n / 2);
        return b * b % mod;
    }
}

struct point{
    ld x, y;
};

ld dist(point a, point b) {
    return sqrt((a.x - b.x) * (a.x - b.x) + (a.y - b.y) * (a.y - b.y));
}

void solve() {
    int n; cin >> n;
    vector <int> a(n);
    for (int i = 0; i < n; i++) {
        cin >> a[i];
    }
    vector <int> ans(n, -1);
    for (int i = 1; i <= n; i++) {
        int free = 0;
        for (int j = n - 1; j >= 0; j--) {
            if (free == a[i - 1] && ans[j] == -1) {
                ans[j] = i;
                break;
            }
            if (ans[j] == -1) {
                free++;
            }
        }
    }
    for (auto i : ans) cout << i << ' ';
}

int main() {
#ifdef LOCAL
    freopen("input.txt", "r", stdin);
    freopen("output.txt", "w", stdout);
#endif
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    int t = 1;
    // cin >> t;
    while (t--) {
        solve();
    }
    return 0;
}