#include <iostream>
#include <vector>
#include <cmath>
#include <iomanip>
#define USE_MATH_DEFINES

using namespace std;

typedef long long ll;
typedef long double ld;

const ll mod = 2286661337;

ll bin_pow(ll a, ll n) {
    if (n == 0) {
        return 1;
    } else if (n % 2 == 1) {
        return a * bin_pow(a, n - 1) % mod;
    } else {
        ll b = bin_pow(a, n / 2);
        return b * b % mod;
    }
}

struct point{
    ld x, y;
};

ld dist(point a, point b) {
    return sqrt((a.x - b.x) * (a.x - b.x) + (a.y - b.y) * (a.y - b.y));
}

void solve() {
    string s; cin >> s;
    for (int begin = 0; begin < 52; begin++) {
        if ('A' + begin % 7 != s[0]) {
            continue;
        }
        int cur_ind = begin;
        bool fl = true;
        for (int i = 1; i < s.size(); i++) {
            bool fl1 = false;
            for (int shift = -3; shift <= 3; shift++) {
                if (cur_ind + shift < 0 || cur_ind + shift >= 52) {
                    continue;
                }
                if (('A' + ((cur_ind + shift) % 7)) == s[i]) {
                    cur_ind = cur_ind + shift;
                    fl1 = true;
                    break;
                }
            }
            if (!fl1) {
                fl = false;
                break;
            }
        }
        if (fl) {
            cout << "Yes\n";
            return;
        }
    }
    cout << "No\n";
}

int main() {
#ifdef LOCAL
    freopen("input.txt", "r", stdin);
    freopen("output.txt", "w", stdout);
#endif
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    int t = 1;
    cin >> t;
    while (t--) {
        solve();
    }
    return 0;
}