#include <bits/stdc++.h>

using namespace std;

using ll = long long;
using ld = long double;

int N = 1e8;
vector<int> col(N + 100, -1);
vector<int> pr(N + 100, 0);

int calc(int x) {
    if (x <= N && col[x] != -1) return col[x];
    if (x >= N) return 1000;
    if (x % 2 == 0) {
        col[x] = calc(x / 2) + log10(x / 2);
    } else {
        col[x] = calc(3 * x + 1) + log10(x / 2);
    }
    return col[x];
}

signed main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int t; cin >> t;

    col[1] = 0;
    for (int i = 2; i < N; ++i) {
        calc(i);
        pr[i] = pr[i - 1] + col[i];
    }

    while (t--) {
        int x;
        cin >> x;
        while (x > 1) {
            if (6 * x >= N) {
                cout << "COLLATZ\n";
            } else if (pr[6 * x] - pr[3 * x] < 3 * x * col[x]) {
                cout << "RANDOM" << endl;
            } else {
                cout << "COLLATZ" << endl;
            }
            cin >> x;
        }
    }
}
