def move1(seq):
    cur = 0
    rot = 0

    for el in seq:
        if el == "L":
            cur = (cur - 1 + 6) % 6
        if el == "R":
            cur = (cur + 1) % 6
        if el == "T":
            if cur == 2:
                cur = 0
            if cur == 0:
                cur = 2
            if cur == 3:
                cur = 5
            if cur == 5:
                cur = 3
            rot += 1
            rot %= 2
    return cur, rot


def sym(hex):
    ans = hex[::]
    for i in range(len(hex)):
        ans[i] = ans[i][::-1]
    return ans


def right(grid):
    if not grid:
        return []

    nrows = len(grid)
    S = (nrows + 1) // 2

    coords_rows = []
    for r_idx in range(nrows):
        r = r_idx - (S - 1)
        qmin = max(-(S - 1), -r - (S - 1))
        qmax = min(S - 1, -r + (S - 1))
        row_len = qmax - qmin + 1
        row_coords = []
        for c in range(row_len):
            q = qmin + c
            x = q
            z = r
            y = -x - z
            row_coords.append((x, y, z))
        coords_rows.append(row_coords)

    rotated_map = {}
    for r_idx, row in enumerate(grid):
        for c, val in enumerate(row):
            coord = coords_rows[r_idx][c]
            x, y, z = coord
            rx, ry, rz = -z, -x, -y
            rotated_map[(rx, ry, rz)] = val

    result = []
    for row_coords in coords_rows:
        res_row = []
        for coord in row_coords:
            res_row.append(rotated_map[coord])
        result.append(res_row)

    return result


n = int(input())
hex = []
for i in range(2 * n - 1):
    hex.append(list(map(int, input().split())))


seq = input()
cur, rot = move1(seq)

cur1 = 0
while cur1 != cur:
    hex = right(hex)
    cur1 = (cur1 + 1) % 6

if rot:
    hex = sym(hex)

print(hex)
