#include <iostream>
#include <vector>
#include <algorithm>
#include <set>
#include <map>
#include <ctime>
#include <random>
#include <climits>
#include <cmath>

using namespace std;

typedef unsigned long long ll;

ll real_max = 100'000'000'000'000;

ll coll(ll x)
{
    if (x > real_max / 3)
        return real_max;
    if (x & 1)
    {
        return 3 * x + 1;
    }
    else
    {
        return x / 2;
    }
}

ll dig(ll x)
{
    ll res = 0;
    while (x > 0)
    {
        res++;
        x /= 10;
    }
    return res;
}

std::map<ll, ll> precalc;

const ll maxTokenCount = 150;

ll calc(ll x)
{
    if (precalc.find(x) != precalc.end())
    {
        return precalc[x];
    }

    ll res = 0;
    while (x != 1 && res < maxTokenCount)
    {
        if (x >= real_max)
        {
            precalc[x] = maxTokenCount + 10;
            return maxTokenCount + 10;
        }
        x = coll(x);
        res++;
    }
    precalc[x] = res;
    return res;
}

void solve()
{
    ll x;
    std::cin >> x;
    if (x == 1) 
        return;
    while (calc(x) >= maxTokenCount)
    {
        while (x % 2 == 0)
        {
            std::cout << "Collatz" << std::endl;
            std::cin >> x;
            if (x == 0)
            {
                exit(0);
            }
        }
        if (x == 1) {
            return;
        }
        std::cout << "Random" << std::endl;
        std::cin >> x;
        if (x == 0)
        {
            exit(0);
        }
    }
    while (x != 1)
    {
        std::cout << "Collatz" << std::endl;
        std::cin >> x;
        if (x == 0)
        {
            exit(0);
        }
    }
}

int main()
{
    std::ios_base::sync_with_stdio(false);
    int t;
    std::cin >> t;
    for (int i = 0;i < t; ++i)
        solve();
}