#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

typedef long long ll;

struct pt
{
    ll x, y;
    pt(ll _x = 0, ll _y = 0) {
        x = _x;
        y = _y;
    }
};
bool cmp(pt a, pt b)
{
    return a.x < b.x || a.x == b.x && a.y < b.y;
}
bool cw(pt a, pt b, pt c)
{
    return a.x * (b.y - c.y) + b.x * (c.y - a.y) + c.x * (a.y - b.y) < 0;
}
bool ccw(pt a, pt b, pt c)
{
    return a.x * (b.y - c.y) + b.x * (c.y - a.y) + c.x * (a.y - b.y) > 0;
}
void convex_hull(vector<pt> &a)
{
    if (a.size() == 1)
        return;
    sort(a.begin(), a.end(), &cmp);
    pt p1 = a[0], p2 = a.back();
    vector<pt> up = {p1}, down = {p1};
    for (int i = 1; i < a.size(); ++i)
    {
        if (i == a.size() - 1 || cw(p1, a[i], p2))
        {
            while (up.size() >= 2 && !cw(up[up.size() - 2], up[up.size() - 1], a[i]))
                up.pop_back();
            up.push_back(a[i]);
        }
        if (i == a.size() - 1 || ccw(p1, a[i], p2))
        {
            while (down.size() >= 2 && !ccw(down[down.size() - 2],
                                            down[down.size() - 1], a[i]))
                down.pop_back();
            down.push_back(a[i]);
        }
    }
    a.clear();
    for (int i = 0; i < up.size(); ++i)
        a.push_back(up[i]);
    for (int i = down.size() - 2; i > 0; --i)
        a.push_back(down[i]);
}

ll mgcd(ll a, ll b) {
    if (a == 0)
        return b;
    return mgcd(b % a, a);
}

ll gcd(ll a, ll b) {
    return mgcd(std::abs(a), std::abs(b));
}


int main() {
    int n;
    cin >> n;
    vector<pt> points(n);
    for (auto& pt : points) {
        cin >> pt.x >> pt.y;
    }
    convex_hull(points);

    ll maxDist = 0;
    ll a1, a2, b1, b2, c1, c2;

    for (int i = 0;i < points.size(); ++i) {
        for (int j = i + 1; j < points.size(); ++j) {
            pt p1 = points[i], p2 = points[j];
            pt v = pt(p1.x - p2.x, p1.y - p2.y);
            if (v.x * v.x + v.y * v.y > maxDist) {
                maxDist = v.x * v.x + v.y * v.y;
                pt u = pt(v.y, -v.x);
                a1 = u.y;
                b1 = -u.x;
                c1 = u.x * p1.y - u.y * p1.x;
                ll d1 = gcd(a1, gcd(b1, c1));
                a1 /= d1;
                b1 /= d1;
                c1 /= d1;

                a2 = u.y;
                b2 = -u.x;
                c2 = u.x * p2.y - u.y * p2.x;
                ll d2 = gcd(a2, gcd(b2, c2));
                a2 /= d2;
                b2 /= d2;
                c2 /= d2;
            }
        }
    }
    std::cout << a1 << " " << b1 << " " << c1 << "\n";
    std::cout << a2 << " " << b2 << " " << c2 << "\n";
}