#include <iostream>
#include <vector>
#include <algorithm>
#include <set>
#include <map>
#include <ctime>
#include <random>
#include <climits>
#include <cmath>

using namespace std;

typedef long long ll;
typedef long double ld;

ld PI = std::acos((ld)-1);
const ll mod = 1e9 + 7;

ll powMod2(ll a, ll n, ll mod) {
    if (n == 0)
        return 1;
    if (n == 1)
        return a;
    ll d = powMod2(a, n / 2, mod);
    d = (d * d) % mod;
    if (n & 1)
        d = (d * a) % mod;
    return d;
}

ll powMod(ll a, ll n, ll mod) {
    if (a == 0)
        return 0;
    if (a == 1)
        return 1;
    return powMod2(a % mod, (n % (mod - 1) + mod - 1) % (mod - 1), mod);
}

struct intp {
    ll x;
    intp(ll a = 0) {
        x = (a % mod + mod) % mod;
    }
    intp operator+(intp& other) {
        return intp(x + other.x);
    }
    intp operator-(intp& other) {
        return intp(x - other.x);
    }
    intp operator*(intp& other) {
        return intp(x * other.x);
    }
    intp operator/(intp& other) {
        return intp(x * powMod(other.x, mod - 2, mod));
    }
};

const int x = 7000000;

int main() {
    std::ios_base::sync_with_stdio(false);
    int t;
    std::cin >> t;
    while(t--) {
        std::string s;
        std::cin >> s;

        int pos = s[0] - 'A' + x;

        int left = x, right = 6 + x;
        for (int i = 1; i < s.size(); ++i) {
            int t = (s[i] - s[i - 1] + 7) % 7;
            if (t <= 3) {
                pos += t;
            }
            else {
                pos -= (7 - t);
            }

            if (pos - pos % 7 < left)
                left = pos - pos % 7;
            if (pos + 6 - pos % 7 > right) 
                right = pos + 6 - pos % 7;
        }
        if (right - left + 1 <= 52)
            std::cout << "YES\n";
        else 
            std::cout << "NO\n";
    }
}