#include<iostream>
#include<iomanip>
#include<string>
#include<vector>
#include<map>
#include<set>
#include<unordered_map>
#include<unordered_set>
#include<queue>
#include<deque>
#include<algorithm>
#include <bitset>
#include <random>
#include <cmath>
#include <bitset>
#include <numbers>
#include<ranges>


using namespace std;
#define var auto
#define range __get_range
mt19937 rnd(time(nullptr));
vector<int> __get_range(int s, int e, int step = 1) {
    int sz = (e - s + step - 1) / step;
    vector<int> res(sz);
    for (int i = 0; i < sz; ++i) {
        res[i] = s + i * step;
    }
    return res;
}
vector<int> __get_range(int e) {return __get_range(0, e);}
template<typename T>
void sort(T& arr) {sort(arr.begin(), arr.end());}
template<typename T>
void reverse(T& arr) {reverse(arr.begin(), arr.end());}
template<typename T>
size_t len(const T& cont) {
    return cont.size();
}
template<typename T>
using dvector = vector<vector<T>>;
typedef long long ll;
typedef long double ld;

struct Point {
    ll x, y;
    Point() {}
    Point(ll x, ll y) : x(x), y(y) {}
};

Point operator -(const Point& a, const Point& b) {
    return Point(a.x - b.x, a.y - b.y);
}

Point operator +(const Point& a, const Point& b) {
    return Point(a.x + b.x, a.y + b.y);
}

double dP(const Point& a, const Point& b) {
    return a.x * b.x + a.y * b.y;
}

double cP(const Point& a, const Point& b) {
    return a.x * b.y - a.y * b.x;
}

double angle(const Point& a, const Point& b) {
    double cp = cP(a, b), dp = dP(a, b);
    if (cp == 0.0) cp = 0.0;
    return atan2(cp, dp);
}

// rotate vector by provided angle
Point rotate(const Point& a, double ang) {
    double cn = cos(ang), sn = sin(ang);
    return Point(a.x * cn - a.y * sn, a.x * sn + a.y * cn);
}

double len(const Point& v) {
    return hypot(v.x, v.y);
}

struct Line {
    ll a, b, c;
    Line(ll a, ll b, ll c) : a(a), b(b), c(c) {}
};

Line lineBy2Pts(const Point& a, const Point& b) {
    return Line(b.y - a.y, a.x - b.x, b.x * a.y - a.x * b.y);
}

Point normal_vector(const Line& l) {
    return Point(l.a, l.b);
}

Point parallel_vector(const Line& l) {
    return Point(l.b, -l.a);
}

double dist_to_line(const Line& l, const Point& p) {
    return abs((l.a * p.x + l.b * p.y + l.c) / hypot(l.a, l.b));
}

int main() {
    ios::sync_with_stdio(0);
    cin.tie(0);
    int n;
    cin >> n;
    vector<Point> a(n);
    for (auto& now : a) {
        cin >> now.x >> now.y;
    }
    ll maxlen = 0;
    Point p1, p2;
    for (int i = 0; i < n; ++i) {
        for (int j = i; j < n; ++j) {
            if ((a[i].x - a[j].x) * (a[i].x - a[j].x) + (a[i].y - a[j].y) * (a[i].y - a[j].y) > maxlen) {
                maxlen = (a[i].x - a[j].x) * (a[i].x - a[j].x) + (a[i].y - a[j].y) * (a[i].y - a[j].y);
                p1 = a[i];
                p2 = a[j];
            }
        }
    }
    Line l = lineBy2Pts(p1, p2);
    Point v = normal_vector(l);
    Line ans1  = lineBy2Pts(p1, p1 + v);
    Line ans2  = lineBy2Pts(p2, p2 + v);
    ll gcd1 = gcd(abs(ans1.a), gcd(abs(ans1.b), abs(ans1.c)));
    ll gcd2 = gcd(abs(ans2.a), gcd(abs(ans2.b), abs(ans2.c)));
    cout << ans1.a / gcd1 << ' ' << ans1.b / gcd1 << ' ' << ans1.c / gcd1 << '\n';
    cout << ans2.a / gcd2 << ' ' << ans2.b / gcd2 << ' ' << ans2.c / gcd2 << '\n';
}
