#include <algorithm>
#include <array>
#include <atomic>
#include <bit>
#include <bitset>
#include <climits>
#include <cmath>
#include <compare>
#include <cstddef>
#include <cstdint>
#include <cstring>
#include <deque>
#include <format>
#include <functional>
#include <ios>
#include <iostream>
#include <istream>
#include <limits>
#include <map>
#include <numeric>
#include <ostream>
#include <queue>
#include <random>
#include <ranges>
#include <set>
#include <unordered_map>

namespace tools {

template <typename T> using vec = std::vector<T>;
template <std::size_t N, typename T> using arr = std::array<T, N>;

template <typename T, typename Comp>
using heap = std::priority_queue<T, vec<T>, Comp>;

template <typename Func> using fn = std::function<Func>;

using i8 = std::int8_t;
using u8 = std::uint8_t;
using i16 = std::int16_t;
using u16 = std::uint16_t;
using i64 = std::int64_t;
using i32 = std::int32_t;
using u64 = std::uint64_t;
using usize = std::size_t;
using isize = std::ptrdiff_t;
using str = std::string;
using f64 = long double;

std::ostream &endl(std::ostream &os) {
  os.put('\n');
  // os.flush();
  return os;
}

template <typename T>
std::istream &operator>>(std::istream &is, std::vector<T> &vector) {
  for (auto &cur : vector) {
    is >> cur;
  }
  return is;
}

void fastIO() {
  std::ios_base::sync_with_stdio(false);
  std::cout.tie(nullptr);
  std::cin.tie(nullptr);
}

template <typename T = i64> struct gcdex_result {
  T gcd;
  T x;
  T y;
};

template <typename T> T sqr(T v) { return v * v; }

template <typename T> gcdex_result<T> gcdex(T a, T b) {
  auto [x1, y1, x2, y2] = std::tuple<T, T, T, T>(1, 0, 0, 1);

  while (b != 0) {
    T k = a / b;
    std::swap(a -= b * k, b);
    std::swap(x1 -= x2 * k, x2);
    std::swap(y1 -= y2 * k, y2);
  }

  return {.gcd = a, .x = x1, .y = y1};
}

// (a ^ n) % MOD
template <typename T = i64> T fpow(T a, T n, T mod) {
  T result = 1;
  a %= mod;
  while (n != 0) {
    if (n % 2 == 1) {
      result = (result * a) % mod;
    }
    n >>= 1;
    a = (a * a) % mod;
  }
  return result;
}

// #undef LOCAL
// #define LOCAL 1
// #ifdef LOCAL
// template <typename... Args>
// void print(std::format_string<Args...> fmt, Args &&...args) {
//   std::cout << std::format(fmt, std::forward<Args>(args)...);
// }

// template <typename... Args>
// void println(std::format_string<Args...> fmt, Args &&...args) {
//   std::cout << std::format(fmt, std::forward<Args>(args)...) << std::endl;
// }
// #else
// template <typename... Args> void println(Args &&...args) {}
// template <typename... Args> void print(Args &&...args) {}
// #endif

} // namespace tools

// namespace rng = std::ranges;
// namespace rv = std::ranges::views;
using std::cin, std::cout;
using std::min, std::max, std::swap;
using std::tie, std::tuple;
using namespace tools;

constexpr u64 MOD = 1e9 + 7;

// mt19937 rnd(std::chrono::steady_clock::now().time_since_epoch().count());
std::mt19937 rnd(42);

void solve();

int main() {
  tools::fastIO();

  int T = 1;
  // cin >> T;

  while (T-- > 0) {
    solve();
  }
}

struct Point {
  i64 x;
  i64 y;

  friend std::strong_ordering operator<=>(const Point &,
                                          const Point &) = default;
};

struct Line {
  i64 A;
  i64 B;
  i64 C;

  static Line from_points(Point p1, Point p2) {
    auto [x1, y1] = p1;
    auto [x2, y2] = p2;

    return Line{
        .A = y2 - y1, .B = x1 - x2, .C = y1 * (x2 - x1) - x1 * (y2 - y1)};
  }

  void up_to(Point p1) { C = -(A * p1.x + B * p1.y); }

  void transpose() {
    i64 a = A, b = B;
    A = -b;
    B = a;
  }
};

struct sol_result {
  Line line1;
  Line line2;
};

sol_result sol(std::vector<Point> &vec) {

  Point fir, sec;
  u64 best_distance = 0;
  for (auto &&first : vec) {
    for (auto &&second : vec) {
      auto distance = u64(sqr(first.x - second.x) + sqr(first.y - second.y));
      if (distance > best_distance) {
        best_distance = distance;
        fir = first;
        sec = second;
      }
    }
  }

  auto oppose = Line::from_points(fir, sec);
  oppose.transpose();
  auto l1 = Line(oppose);
  auto l2 = Line(oppose);
  l1.up_to(fir);
  l2.up_to(sec);

  return sol_result{
      l1,
      l2,
  };
}

void solve() {
  usize n;
  cin >> n;
  vec<Point> pnt(n);

  for (usize i = 0; i < n; ++i) {
    i64 x, y;
    cin >> x >> y;
    pnt[i].x = x;
    pnt[i].y = y;
  }

  auto [l1, l2] = sol(pnt);
  auto [A1, B1, C1] = l1;
  auto [A2, B2, C2] = l2;
  cout << A1 << ' ' << B1 << ' ' << C1 << endl;
  cout << A2 << ' ' << B2 << ' ' << C2 << endl;
}
