#include <algorithm>
#include <array>
#include <atomic>
#include <bit>
#include <bitset>
#include <climits>
#include <cmath>
#include <compare>
#include <cstddef>
#include <cstdint>
#include <cstring>
#include <deque>
#include <format>
#include <functional>
#include <ios>
#include <iostream>
#include <istream>
#include <limits>
#include <map>
#include <numeric>
#include <ostream>
#include <queue>
#include <random>
#include <ranges>
#include <set>
#include <unordered_map>

namespace tools {

template <typename T> using vec = std::vector<T>;
template <std::size_t N, typename T> using arr = std::array<T, N>;

template <typename T, typename Comp>
using heap = std::priority_queue<T, vec<T>, Comp>;

template <typename Func> using fn = std::function<Func>;

using i8 = std::int8_t;
using u8 = std::uint8_t;
using i16 = std::int16_t;
using u16 = std::uint16_t;
using i64 = std::int64_t;
using i32 = std::int32_t;
using u64 = std::uint64_t;
using usize = std::size_t;
using isize = std::ptrdiff_t;
using str = std::string;
using f64 = long double;

std::ostream &endl(std::ostream &os) {
  os.put('\n');
  // os.flush();
  return os;
}

template <typename T>
std::istream &operator>>(std::istream &is, std::vector<T> &vector) {
  for (auto &cur : vector) {
    is >> cur;
  }
  return is;
}

void fastIO() {
  std::ios_base::sync_with_stdio(false);
  std::cout.tie(nullptr);
  std::cin.tie(nullptr);
}

template <typename T = i64> struct gcdex_result {
  T gcd;
  T x;
  T y;
};

template <typename T> T sqr(T v) { return v * v; }

template <typename T> gcdex_result<T> gcdex(T a, T b) {
  auto [x1, y1, x2, y2] = std::tuple<T, T, T, T>(1, 0, 0, 1);

  while (b != 0) {
    T k = a / b;
    std::swap(a -= b * k, b);
    std::swap(x1 -= x2 * k, x2);
    std::swap(y1 -= y2 * k, y2);
  }

  return {.gcd = a, .x = x1, .y = y1};
}

// (a ^ n) % MOD
template <typename T = i64> T fpow(T a, T n, T mod) {
  T result = 1;
  a %= mod;
  while (n != 0) {
    if (n % 2 == 1) {
      result = (result * a) % mod;
    }
    n >>= 1;
    a = (a * a) % mod;
  }
  return result;
}

// #undef LOCAL
// #define LOCAL 1
// #ifdef LOCAL
// template <typename... Args>
// void print(std::format_string<Args...> fmt, Args &&...args) {
//   std::cout << std::format(fmt, std::forward<Args>(args)...);
// }

// template <typename... Args>
// void println(std::format_string<Args...> fmt, Args &&...args) {
//   std::cout << std::format(fmt, std::forward<Args>(args)...) << std::endl;
// }
// #else
// template <typename... Args> void println(Args &&...args) {}
// template <typename... Args> void print(Args &&...args) {}
// #endif

} // namespace tools

// namespace rng = std::ranges;
// namespace rv = std::ranges::views;
using std::cin, std::cout;
using std::min, std::max, std::swap;
using std::tie, std::tuple;
using namespace tools;

constexpr u64 MOD = 1e9 + 7;

// mt19937 rnd(std::chrono::steady_clock::now().time_since_epoch().count());
std::mt19937 rnd(42);

void solve();

int main() {
  tools::fastIO();

  int T = 1;
  // cin >> T;

  while (T-- > 0) {
    solve();
  }
}

void solve() {

  usize k;
  cin >> k;

  usize n;
  cin >> n;
  vec<usize> a(n);
  cin >> a;

  usize s = 0;
  for (auto &&cur : a) {
    s += cur;
  }

  if (k == 0) {
    cout << (s % n) + 1 << endl;
  } else {
    --k;
    ++n;
    s %= n;

    auto v = (k - s + n) % n;
    if (v == 0)
      v = n;
    cout << v << endl;
  }
}
