#include <time.h>

#include <algorithm>
#include <cassert>
#include <chrono>
#include <cmath>
#include <complex>
#include <cstring>
#include <fstream>
#include <iomanip>
#include <iostream>
#include <map>
#include <numeric>
#include <queue>
#include <random>
#include <set>
#include <stack>
#include <string>
#include <unordered_map>
#include <unordered_set>
#include <vector>
#include <bitset>
using namespace std::chrono;

#define all(x) x.begin(), x.end()

using namespace std;

typedef long long ll;
typedef pair<int, int> pi;
typedef pair<ll, ll> pl;
typedef vector<int> vi;
typedef vector<ll> vl;
typedef vector<bool> vb;
typedef vector<pi> vpi;

bool inside(ll value, ll left, ll right) {
  return (left <= value && value <= right);
}

ll gcd(ll a, ll b) {
  while (b > 0) {
    ll tmp = b;
    b = a % b;
    a = tmp;
  }
  return a;
}

ll bin_pow(ll a, ll exp, ll mod) {
  ll res = 1;
  while (exp) {
    if (exp & 1) res = (res * a) % mod;
    a = (a * a) % mod;
    exp >>= 1;
  }
  return res;
}

int inverse(int a, int m) {
  int g = m, r = a, x = 0, y = 1;
  while (r != 0) {
    int q = g / r;
    g %= r;
    swap(g, r);
    x -= q * y;
    swap(x, y);
  }
  return x < 0 ? x + m : x;
}

const int INF = 2e9 + 1;
const ll LINF = 9e18;
const int MOD = 1e9 + 7;  // 1e9 + 7;
const int N = 2e7 + 500, M = 700;

ll mulmod(ll a, ll b, ll mod) {
  ll x = 0, y = a % mod;
  while (b > 0) {
    if (b % 2 == 1) {
      x = (x + y) % mod;
    }
    y = (y * 2) % mod;
    b /= 2;
  }
  return x % mod;
}

pi f(int n, int rot, int i, int j) {
    int R2 = (i < n ? -n + 1 : -n + 1 + i - n + 1) + j;
    int G2 = min(n - 1, i) - j;
    int B2 =  n - i - 1;
    int tg, tr, tb;
    int rot2 = 6 - rot;
    while (rot2--) {
        tg = G2, tr = R2, tb = B2;
        R2 = -tg, B2 = -tr, G2 = -tb;
        // cout << tg << ' ' << tb << ' ' << tr << ' ' << R2 << ' ' << G2 << ' ' << B2 << '\n';
    }
    int i2 = n - B2 - 1;
    int j2 = min(n - 1, i2) - G2;
    return {i2, j2};
}

void solve() {
    int n;
    cin >> n;
    unordered_map<int, unordered_map<int, short>> arr;
    // vector<vector<short>> arr(2 * n, vector<short>(2 * n));
    for (int i = 0; i < 2 * n - 1; i++) {
        int lim = (i < n ? n + i : 2 * n - (i - n) - 2);
        for (int j = 0; j < lim; j++) {
            int x;
            cin >> x;
            arr[i][j] = x;
        }
    }
    string s;
    cin >> s;
    int rot = 0;
    bool inv = false;
    for (char c : s) {
        if (c == 'L') {
            rot -= (!inv ? 1 : -1);
        } else if (c == 'R') {
            rot += (!inv ? 1 : -1);
        } else {
            inv = !inv;
        }
    }
    if (rot < 0) rot += 6;
    
    for (int i = 0; i < 2 * n - 1; i++) {
        int lim = (i < n ? n + i : 2 * n - (i - n) - 2);
        for (int j = 0; j < lim; j++) {
            int j2 = lim - j - 1;
            pi p;
            if (inv) {
                p = f(n, rot, i, j2);
            } else {
                p = f(n, rot, i, j);
            }
            cout << arr[p.first][p.second] << ' ';
        }
        cout << '\n';
    }
}
int main() {
//   ios_base::sync_with_stdio(false), cin.tie(0), cout.tie(0);
#ifdef LOCAL
  freopen("input.in", "r", stdin);
#endif
  int t = 1;
//   cin >> t;
  for (int i = 0; i < t; i++) {
    string s = "Testcase #";
    // s += ('0' + i);
    // print(s, 2);
    solve();
    // print("-----------\n");
  }
}