#pragma GCC optimize("O3")

#include <algorithm>
#include <bitset>
#include <cinttypes>
#include <cstdint>
#include <exception>
#include <iostream>
#include <limits>
#include <set>
#include <utility>
#include <vector>

using namespace std;

template <typename T, typename U>
__attribute__((always_inline)) inline void insert_sorted(std::vector<T> &vec,
                                                         const U &value) {
  auto it = std::upper_bound(vec.begin(), vec.end(), value);
  vec.insert(it, value);
}

#pragma GCC target("bmi,bmi2,avx2")
int main() {
  long long n, s;

  vector<int32_t> V;
  bitset<999984> a;
  V.reserve(110000);

  cin >> n >> s;

  int32_t min_set = s;
  int32_t max_set = s;

  for (long long i = 0; i < n; i++) {
    s = (s * 618023 + 1) % 999983;

    long long j = 0;

    for (const auto v : V) {
      const auto dif = s - v;

      if (dif < v || dif < min_set) {
        break;
      }

      if (dif > max_set) {
        continue;
      }

      if (a._Unchecked_test(dif)) {
        j++;
      }
    }

    if (j % 2 == 0 && !a._Unchecked_test(s)) {
      min_set = min<int32_t>(s, min_set);
      max_set = max<int32_t>(s, max_set);
      a._Unchecked_set(s);
      insert_sorted(V, s);
    }
  }

  cout << V.size();

  return 0;
}
