#include <bits/stdc++.h>

using namespace std;

using ll = long long;


int main() {
  ios_base::sync_with_stdio(0);
  cin.tie(0);

  int n; cin >> n;

  deque<deque<int>> hex(2 * n - 1);
  for (int i = 0; i < 2 * n - 1; i++) {
    hex[i].resize(2 * n - 1 - abs(i - (n - 1)));
    for (int j = 0; j < hex[i].size(); j++)
      cin >> hex[i][j];
  }

  vector<vector<int>> layers;
  for (int i = 0; i < n - 1; i++) {
    vector<int> layer;
    for (int j = 0; j < hex.front().size(); j++) {
      layer.push_back(hex.front()[j]);
    }
    hex.pop_front();
    for (int j = 0; j < hex.size(); j++) {
      layer.push_back(hex[j].back());
      hex[j].pop_back();
    }
    for (int j = hex.back().size() - 1; j > -1; j--) {
      layer.push_back(hex.back()[j]);
    }
    hex.pop_back();
    for (int j = hex.size() - 1; j > -1; j--) {
      layer.push_back(hex[j].front());
      hex[j].pop_front();
    }

    layers.push_back(layer);
  }
  //layers.push_back({hex[0][0]});

  string cmd;
  cin >> cmd;

  int angle = 0, mirror = 1;
  for (char c : cmd) {
    if (c == 'L')
      angle += mirror;
    if (c == 'R')
      angle -= mirror;
    if (c == 'T')
      mirror *= -1;
  }
  angle = (angle + 6000000) % 6;

  reverse(layers.begin(), layers.end());
  for (int i = 0; i < n - 1; i++) {
    queue<int> layer;
    int shift = angle * (i + 1);
    for (int j = 0; j < layers[i].size(); j++)
      layer.push(layers[i][(j + shift) % layers[i].size()]);

    hex.push_front({});
    for (int j = 0; j < i + 1; j++) {
      hex.front().push_back(layer.front());
      layer.pop();
    }
    for (int j = 0; j < hex.size(); j++) {
      hex[j].push_back(layer.front());
      layer.pop();
    }
    hex.push_back({});
    for (int j = i; j > -1; j--) {
      hex.back().push_front(layer.front());
      layer.pop();
    }
    for (int j = hex.size() - 1; j > 0; j--) {
      hex[j].push_front(layer.front());
      layer.pop();
    }
    if(!layer.empty()) {
      break;
    }

  }

  for (auto row : hex) {
    while (!row.empty()) {
      if (mirror == 1) {
        cout << row.front() << " ";
        row.pop_front();
      } else {
        cout << row.back() << " ";
        row.pop_back();
      }
    }
    cout << "\n";
  }

  return 0;
}