#include <iostream>
#include <unordered_set>
#include <vector>
#include <set>
#include <map>
#include <algorithm>

using namespace std;

#define int long long

void print_hex(vector<vector<int>>& hex) {
    int n = hex[0].size();
    for (int i = 0; i < n; ++i) {
        for (int j = 0; j < n - i - 1; ++j) {
            cout << " ";
        }
        for (auto j: hex[i]) {
            cout << j << " ";
        }
        cout << "\n";
    }

    for (int i = 0; i < n - 1; ++i) {
        for (int j = 0; j < i + 1; j++) {
            cout << " ";
        }

        for (auto j: hex[n + i]) {
            cout << j << " ";
        }
        cout << "\n";
    }
    cout << "\n";
}

pair<bool, int> make_move(char mov, bool t, int turns) {
    if (mov == 'L') {
        if (t) {
            turns = (turns - 1 + 6) % 6;
        } else {
            turns = (turns + 1) % 6;
        }
    }
    if (mov == 'R') {
        if (t) {
            turns = (turns + 1) % 6;
        } else {
            turns = (turns - 1 + 6) % 6;
        }
    }

    if (mov == 'T') {
        t = !t;
    }
    return make_pair(t, turns);
}

vector<vector<int>> trans(vector<vector<int>>& hex) {
    int ind = 0;
    int n = hex[0].size();
    vector<vector<int>> new_hex(2 * n - 1, vector<int>());
    for (vector<int> i: hex) {
        reverse(i.begin(), i.end());
        for (auto j: i) {
            new_hex[ind].push_back(j);
        }
        ind++;
    }
    return new_hex;
}

vector<int> reversed(const vector<int>& vec) {
    vector<int> result;
    result.reserve(vec.size());

    for (int i = vec.size() - 1; i >= 0; --i) {
        result.push_back(vec[i]);
    }

    return result;
}


vector<vector<int>> rotat(vector<vector<int>>& hex) {
    int n = hex[0].size();
    vector<vector<int>> new_hex(2 * n - 1, vector<int>());
    for (int i = 0; i < n; ++i) {
        for (int j = 0; j < hex[i].size(); ++j) {
            new_hex[j].push_back(hex[i][j]);
        }
    }
    for (int i = 1; i < n; ++i) {
        for (int j = 0; j < hex[i + n - 1].size(); ++j) {
            new_hex[j + i].push_back(hex[i + n - 1][j]);
        }
    }
    int ind = 0;
    for (vector<int> i: new_hex) {
        new_hex[ind] = reversed(i);
        ind++;
    }
    return new_hex;
}

signed main() {
    /*ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);*/

    int n;
    cin >> n;
    int turns = 0;
    bool t = false;
    vector<vector<int>> initial(2 * n - 1, vector<int>());
    for (int i = 0; i < n; ++i) {
        for (int j = 0; j < n + i; ++j) {
            int x;
            cin >> x;
            initial[i].push_back(x);
        }
    }
    for (int i = 0; i < n - 1; ++i) {
        for (int j = 0; j < 2 * n - 2 - i; ++j) {
            int x;
            cin >> x;
            initial[i + n].push_back(x);
        }
    }
    string s;
    cin >> s;
    for (auto i: s) {
        auto a = make_move(i, t, turns);
        t = a.first;
        turns = a.second;
    }
    if (t) {
        initial = trans(initial);
    }
    if (!t) {
        turns = 6 - turns;
    }
    for (int i = 0; i < turns; ++i) {
        initial = rotat(initial);
    }
    print_hex(initial);
}
