#include <iostream>
#include <vector>
#include <cmath>
#include <algorithm>

using namespace std;

struct pt {
    double x = 0, y = 0;

    pt() = default;

    pt(double a, double b) {
        x = a;
        y = b;
    }
};

struct vec {
    pt begin, end;

    vec(pt a, pt b) {
        begin = a;
        end = b;
    }

    double x() {
        return end.x - begin.x;
    }

    double y() {
        return end.y - begin.y;
    }

    double len() {
        return sqrt(x() * x() + y() * y());
    }
};

struct line {
    double a, b, c;

    line(vec norm, pt s) {
        a = norm.x();
        b = norm.y();
        c = 0 - s.x * a - s.y * b;
    }
};

double scal(vec a, vec b) {
    return a.x() * b.x() + a.y() * b.y();
}

bool cmp(pt a, pt b) {
    return a.x < b.x || a.x == b.x && a.y < b.y;
}

int w(const pt& a, const pt& b, const pt& c) {
    if ((b.x - a.x) * (c.y - a.y) - (c.x - a.x) * (b.y - a.y) < 0) {
        return -1;
    }
    else {
        return 1;
    }
}

bool cw(const pt& a, const pt& b, const pt& c) {
    return w(a, b, c) < 0;
}

bool ccw(const pt& a, const pt& b, const pt& c) {
    return w(a, b, c) > 0;
}

void convex_hull(vector<pt>& a) {
    if (a.size() == 1)  return;
    sort(a.begin(), a.end(), &cmp);
    pt p1 = a[0], p2 = a.back();
    vector<pt> up, down;
    up.push_back(p1);
    down.push_back(p1);
    for (size_t i = 1; i < a.size(); ++i) {
        if (i == a.size() - 1 || cw(p1, a[i], p2)) {
            while (up.size() >= 2 && !cw(up[up.size() - 2], up[up.size() - 1], a[i]))
                up.pop_back();
            up.push_back(a[i]);
        }
        if (i == a.size() - 1 || ccw(p1, a[i], p2)) {
            while (down.size() >= 2 && !ccw(down[down.size() - 2], down[down.size() - 1], a[i]))
                down.pop_back();
            down.push_back(a[i]);
        }
    }
    a.clear();
    for (size_t i = 0; i < up.size(); ++i)
        a.push_back(up[i]);
    for (size_t i = down.size() - 2; i > 0; --i)
        a.push_back(down[i]);
}

int main() {
    int n, a, b;
    cin >> n;
    vector<pt> points;
    for (int i = 0; i < n; i++) {
        cin >> a >> b;
        points.push_back(pt(a, b));
    }
    convex_hull(points);

    n = points.size();
    double max_len = 0;
    pair<int, int> max_ver(0, 0);
    for (size_t i = 0; i < n; i++) {
        for (size_t j = 0; j < n; j++) {
            vec perp(points[i], points[j]);
            if (perp.len() > max_len) {
                double ed1 = scal(perp, vec(points[i], points[(i + 1) % n]));
                double ed2 = scal(perp, vec(points[i], points[(i - 1 + n) % n]));
                double ed3 = scal(perp, vec(points[j], points[(j + 1) % n]));
                double ed4 = scal(perp, vec(points[j], points[(j - 1 + n) % n]));
                if ((ed1 > 0 && ed2 > 0) || (ed1 < 0 && ed2 < 0)) {
                    if ((ed3 > 0 && ed4 > 0) || (ed3 < 0 && ed4 < 0)) {
                        max_len = perp.len();
                        max_ver = { i, j };
                    }
                }
            }
        }
    }
    vec perp(points[max_ver.first], points[max_ver.second]);
    line l1(perp, points[max_ver.first]);
    line l2(perp, points[max_ver.second]);
    cout << l1.a << ' ' << l1.b << ' ' << l1.c << '\n';
    cout << l2.a << ' ' << l2.b << ' ' << l2.c << '\n';
}