#include <iostream>
#include <vector>
#include <algorithm>
#include <iomanip>
#include <string>
#include <random>
#include <typeinfo>
#include <map>
#include <set>
#include <cassert>
#include <queue>
#include <unordered_map>
#include <functional>
#include <bitset>

using std::cin, std::cout, std::cerr, std::endl;
using std::vector, std::queue, std::deque, std::array, std::string,
        std::map, std::set, std::unordered_map, std::tuple;
using std::istream, std::ostream;
using std::min, std::max;
using std::abs, std::sort;

template<typename T, typename V = T>
using pair = std::pair<T, V>;

//#pragma GCC optimize("O3")
//#pragma GCC optimize("unroll-loops")
//#pragma GCC target("avx2,popcnt,tune=native")

using ll = long long;
using ull = unsigned long long;
using dl = long double;

#define all(x) (x).begin(), (x).end()

template<typename T>
std::ostream &operator<<(std::ostream &out, const pair<T, T> &a) {
    out << '(' << a.first << ' ' << a.second << ')';
    return out;
}

template<typename T, typename V>
std::istream &operator>>(std::istream &in, pair<T, V> &a) {
    in >> a.first >> a.second;
    return in;
}

template<typename T>
std::istream &operator>>(std::istream &in, vector<T> &a) {
    for (size_t i = 0; i < a.size(); i++) {
        in >> a[i];
    }
    return in;
}

struct int_mod;

//template<typename T>
//concept StringLike = std::same_as<std::remove_cvref_t<T>, std::string> ||
//                     std::convertible_to<T, std::string_view>;
//
//template<typename T>
//concept Iterable = std::ranges::range<T> && (!StringLike<T>);
//
//template<Iterable Container>
//std::ostream &operator<<(std::ostream &out, const Container &container) {
//    using value_type = std::decay_t<decltype(*std::begin(container))>;
//
//    char separator = (std::is_arithmetic_v<value_type> || std::is_same_v<value_type, int_mod>)
//                     ? ' '
//                     : '\n';
//
//    for (const auto &i: container) {
//        out << i << separator;
//    }
//    return out;
//}

// c++17 version
template<typename T>
std::ostream &operator<<(std::ostream &out, const vector<T> &container) {
    char separator = (std::is_arithmetic_v<T> || std::is_same_v<T, int_mod>)
                     ? ' '
                     : '\n';

    for (const auto &i: container) {
        out << i << separator;
    }
    return out;
}

template<typename T>
bool mini(T &a, const T &b) {
    if (a > b) {
        a = b;
        return true;
    }
    return false;
}

template<typename T>
bool maxi(T &a, const T &b) {
    if (a < b) {
        a = b;
        return true;
    }
    return false;
}

template<typename T>
T binpow(const T &a, ll exp) {
    T res(1);
    T base = a;
    while (exp > 0) {
        if (exp & 1)
            res *= base;
        base *= base;
        exp /= 2;
    }
    return res;
}

struct int_mod {
    static const int MOD = 1'000'000'007;
//    static const int MOD = 998'244'353;
private:
    int val;

public:
    int_mod() : val(0) {}

    int_mod(int x) {
        val = (x % MOD + MOD) % MOD;
    }

    int_mod(ll x) {
        val = (int) ((x % MOD + MOD) % MOD);
    }

    operator int() const {
        return val;
    }

    int_mod &operator+=(const int_mod &other) {
        val += other.val;
        if (val >= MOD)
            val -= MOD;
        return *this;
    }

    int_mod &operator-=(const int_mod &other) {
        val -= other.val;
        if (val < 0)
            val += MOD;
        return *this;
    }

    int_mod &operator*=(const int_mod &other) {
        val = static_cast<int>(static_cast<long long>(val) * other.val % MOD);
        return *this;
    }

    int_mod &operator/=(const int_mod &other) {
        return *this *= other.inv();
    }

    int_mod inv() const {
        return binpow(*this, MOD - 2);
    }

    friend int_mod operator+(int_mod a, const int_mod &b) {
        a += b;
        return a;
    }

    friend int_mod operator+(int_mod a, int b) {
        a += b;
        return a;
    }

    friend int_mod operator-(int_mod a, const int_mod &b) {
        a -= b;
        return a;
    }

    friend int_mod operator-(int_mod a, int b) {
        a -= b;
        return a;
    }

    friend int_mod operator*(int_mod a, const int_mod &b) {
        a *= b;
        return a;
    }

    friend int_mod operator*(int_mod a, int b) {
        a *= b;
        return a;
    }

    friend int_mod operator/(int_mod a, const int_mod &b) {
        a /= b;
        return a;
    }

    friend int_mod operator/(int_mod a, int_mod b) {
        a /= b;
        return a;
    }

    friend std::ostream &operator<<(std::ostream &os, const int_mod &m) {
        return os << m.val;
    }

    friend std::istream &operator>>(std::istream &is, int_mod &m) {
        int x;
        is >> x;
        m = int_mod(x);
        return is;
    }
};


constexpr ll MOD = 999'983;
constexpr ll base = 618'023;
constexpr int B = 3000;

//std::bitset<MOD> sum;
//std::bitset<MOD> v;

#include <numbers>

    const long double pi = acos(-1);

    struct Complex {
        long double a, b;

        Complex(long long x) : a(x), b(0) {
        }

        Complex(long double _a, long double _b): a(_a), b(_b) {
        }

        Complex(): a(0), b(0) {
        }

        Complex operator +(const Complex &other) const {
            return {a + other.a, b + other.b};
        }

        Complex operator -(const Complex &other) const {
            return {a - other.a, b - other.b};
        }

        Complex operator *(const Complex &other) const {
            return {a * other.a - b * other.b, a * other.b + b * other.a};
        }

        friend std::ostream &operator <<(std::ostream &out, const Complex &z) {
            out << z.a << ' ' << z.b;
            return out;
        }
    };

    const int LOG_N = 21;
    const int N = 1 << LOG_N;
    Complex es[N * 2];
    uint32_t rev[N];
    int precalced = -1;

    void precalc_fft(int lg) {
        es[0] = Complex(1, 0);
        int p = 1;
        for (int j = 1; j <= lg; ++j) {
            es[p++] = Complex(1, 0);
            for (int i = 1; i < (1 << (j - 1)); ++i) {
                long double angle = (2 * pi) / (long double) (1 << j) * i;
                es[p++] = Complex(std::cos(angle), std::sin(angle));
            }
        }
        rev[0] = 0;
        for (int i = 1; i < N; ++i) {
            rev[i] = (rev[i / 2] / 2) | ((1 & i) << (lg - 1));
            rev[i] %= 2;
        }
        precalced = lg;
    }

    std::vector<Complex> fft(std::vector<Complex> p) {
        int lvl = LOG_N;
        if (precalced != lvl) {
            precalc_fft(lvl);
        }
        for (int i = 0; i < p.size(); ++i) {
            if (i <= rev[i])
                std::swap(p[rev[i]], p[i]);
        }
        int g_pt = 1;
        for (int j = 1; j <= lvl; ++j) {
            int half = 1 << (j - 1);
            for (int s = 0; s < p.size(); s += (1 << j)) {
                int pt = g_pt;
                for (int i = s; i < s + half; ++i) {
                    Complex a = p[i], b = p[i + half];
                    p[i] = a + es[pt] * b;
                    p[i + half] = a - es[pt] * b;
                    ++pt;
                }
            }
            g_pt += half;
        }
        return p;
    }

    struct bigint {
        using digit_t = int64_t;
        int sign;
        std::vector<digit_t> digit;

        bigint(int64_t x) {
            sign = (x < 0) ? -1 : 1;
            digit = {std::abs(x)};
            digit.resize(N);
            normalize();
        }

        bigint(): sign(1), digit(std::vector<digit_t>{0}) {
            digit.resize(N);
        }

        bigint &flip() {
            sign *= -1;
            return *this;
        }

        bigint operator -() const {
            auto res = *this;
            return res.flip();
        }

        void set(size_t ind, digit_t d) {
            if (ind < digit.size()) {
                digit[ind] = d;
            }
        }

        digit_t get(size_t ind) const {
            if (ind < digit.size()) {
                return digit[ind];
            }
            return 0;
        }

        size_t size() const {
            return digit.size();
        }

        void normalize() {
//            if (size() > MOD) {
//                digit.resize(MOD);
//            }
//            digit_t prev = 0;
//            size_t i = 0;
//            while (i < size() || prev != 0) {
//                digit_t d = get(i) + prev;
//
//                set(i, d % base);
//                prev = d / base;
//                ++i;
//            }

//            remove_lz();
        }

        void remove_lz() {
//            while (digit.size() > 1 && digit.back() == 0) {
//                digit.pop_back();
//            }
        }

        bool unsigned_less(const bigint &other) const {
            if (size() != other.size()) {
                return size() < other.size();
            }
            for (size_t i = 1; i <= size(); ++i) {
                if (digit[size() - i] != other.digit[size() - i]) {
                    return digit[size() - i] < other.digit[size() - i];
                }
            }
            return false;
        }

        bool operator==(const bigint &other) const {
            return sign == other.sign && digit == other.digit;
        }

        bool operator <(const bigint &other) const {
            return sign < other.sign || (sign > 0 && unsigned_less(other)) || (sign < 0 && other.unsigned_less(*this));
        }

        bool operator >=(const bigint &other) const {
            return !(*this < other);
        }

        bool operator >(const bigint &other) const {
            return other < *this;
        }


        bigint &unisgned_add(const bigint &other) {
            digit_t prev = 0;
            size_t i = 0;
            while (i < other.size() || prev != 0) {
                digit_t d = get(i) + other.get(i) + prev;

                set(i, d % base);
                prev = d / base;
                ++i;
            }
            remove_lz();
            return *this;
        }

        bigint &unisgned_sub(const bigint &other) {
            // |this| > |other|
            for (int i = 0; i < other.size(); ++i) {
                digit[i] -= other.digit[i];
                if (digit[i] < 0) {
                    digit[i] += base;
                    digit[i + 1] -= 1;
                }
            }
            remove_lz();
            return *this;
        }

        bigint &operator +=(const bigint &other) {
            if (sign == other.sign) {
                return unisgned_add(other);
            } else {
                if (unsigned_less(other)) {
                    bigint copy = other;
                    copy.unisgned_sub(*this);
                    *this = copy;
                } else {
                    unisgned_sub(other);
                }
            }
            return *this;
        }

        bigint &operator -=(const bigint &other) {
            if (sign != other.sign) {
                return unisgned_add(other);
            } else {
                if (unsigned_less(other)) {
                    bigint copy = other;
                    copy.unisgned_sub(*this);
                    copy.sign *= -1;
                    *this = copy;
                } else {
                    unisgned_sub(other);
                }
                return *this;
            }
        }

        friend bigint operator +(const bigint &lhs, const bigint &rhs) {
            bigint copy = lhs;
            copy += rhs;
            return copy;
        }

        friend bigint operator -(const bigint &lhs, const bigint &rhs) {
            bigint copy = lhs;
            copy -= rhs;
            return copy;
        }

        static int num_len(digit_t n) {
            if (n == 0)
                return 1;
            int res = 0;
            while (n > 0) {
                n /= 10;
                ++res;
            }
            return res;
        }

        friend std::ostream &operator <<(std::ostream &out, const bigint &x) {
            /// works only if base is a power of 10
            if (x.sign < 0) {
                std::cout << '-';
            }
            out << x.digit.back();
            for (int i = x.digit.size() - 2; i >= 0; --i) {
                out << x.digit[i] << ' ';
            }
            return out;
        }

        friend bigint operator *(const bigint &lhs, const bigint &rhs) {
            /// check that precalc for FFT was done and has enough indexes
            std::vector<Complex> a(N), b(N);
            std::copy(lhs.digit.begin(), lhs.digit.end(), a.begin());
            std::copy(rhs.digit.begin(), rhs.digit.end(), b.begin());
            a = fft(a);
            b = fft(b);
            std::vector<Complex> c(N);
            for (int i = 0; i < N; ++i) {
                c[i] = a[i] * b[i];
            }
            c = fft(c);
            bigint res;
            res.digit.resize(N);
            for (int i = 0; i < res.size(); ++i) {
                res.digit[i] = std::roundl(c[i].a / N);
            }
            std::reverse(res.digit.begin() + 1, res.digit.end());
            for (int i = MOD; i < res.size(); ++i) {
                res.digit[i] = 0;
            }
            res.sign = lhs.sign * rhs.sign;
            return res;
        }

        bigint &operator *=(const bigint &other) {
            return *this = *this * other;
        }

        bigint &operator *=(digit_t x) {
            /// for x < base
            for (size_t i = 0; i < size(); ++i) {
                digit[i] *= x;
            }
            normalize();
            if (x < 0) {
                sign *= -1;
            }
            return *this;
        }

        friend bigint operator *(const bigint &lhs, digit_t x) {
            auto res = lhs;
            res *= x;
            return res;
        }

    };


void solve() {
    ll n, s;
    cin >> n >> s;
    int i = 0;
    bigint sum;
    bigint v;
    int ans = 0;
    for (int i = 0; i < n; i += B) {
        bigint cur_ans;
        bigint cur_v;
        vector<int> vv;
        for (int j = 0; j < B && i + j < n; ++j) {
            s = (base * s + 1) % MOD;
            ll cur_cnt = sum.get(s) + cur_ans.get(s);
            for (int x :vv) {
                if (x <= s && v.get(s - x) > 0) {
                    ++cur_cnt;
                }
            }
            if (cur_cnt % 2 == 1) {
                continue;
            }
            ++ans;
            cur_v.set(s, 1);
            vv.push_back(s);
            for (int x :vv) {
                if (x + s > MOD) {
                    continue;
                }
                cur_ans.set(x + s, cur_ans.get(x + s) + 1);
            }
        }
        sum += cur_v * v;
        for (int x : vv) {
            v.set(x, 1);
        }
//            if (sum[s] == 0) {
//                v[s] = true;
//                sum ^= (v << s);
//            }
        }
    cout << ans;
}

signed main() {
#ifdef pskobx
    freopen("input", "r", stdin);
    freopen("out", "w", stdout);
#endif
#ifndef pskobx
    std::ios::sync_with_stdio(false);
    cin.tie(nullptr);
#endif

    int tests = 1;
//    cin >> tests;

    while (tests--) {
        solve();
//        cout << '\n';
    }
}

