#include <iostream>
#include <vector>
#include <algorithm>
#include <iomanip>
#include <string>
#include <random>
#include <typeinfo>
#include <map>
#include <set>
#include <cassert>
#include <queue>
#include <unordered_map>
#include <functional>

using std::cin, std::cout, std::cerr, std::endl;
using std::vector, std::queue, std::deque, std::array, std::string,
        std::map, std::set, std::unordered_map, std::tuple;
using std::istream, std::ostream;
using std::min, std::max;
using std::abs, std::sort;

template<typename T, typename V = T>
using pair = std::pair<T, V>;

// #pragma GCC optimize("O3")
// #pragma GCC optimize("unroll-loops")
// #pragma GCC target("avx2,popcnt,tune=native")

using ll = long long;
using ull = unsigned long long;
using dl = long double;

#define all(x) (x).begin(), (x).end()

template<typename T>
std::ostream &operator<<(std::ostream &out, const pair<T, T> &a) {
    out << '(' << a.first << ' ' << a.second << ')';
    return out;
}

template<typename T, typename V>
std::istream &operator>>(std::istream &in, pair<T, V> &a) {
    in >> a.first >> a.second;
    return in;
}

template<typename T>
std::istream &operator>>(std::istream &in, vector<T> &a) {
    for (size_t i = 0; i < a.size(); i++) {
        in >> a[i];
    }
    return in;
}

struct int_mod;

//template<typename T>
//concept StringLike = std::same_as<std::remove_cvref_t<T>, std::string> ||
//                     std::convertible_to<T, std::string_view>;
//
//template<typename T>
//concept Iterable = std::ranges::range<T> && (!StringLike<T>);
//
//template<Iterable Container>
//std::ostream &operator<<(std::ostream &out, const Container &container) {
//    using value_type = std::decay_t<decltype(*std::begin(container))>;
//
//    char separator = (std::is_arithmetic_v<value_type> || std::is_same_v<value_type, int_mod>)
//                     ? ' '
//                     : '\n';
//
//    for (const auto &i: container) {
//        out << i << separator;
//    }
//    return out;
//}

// c++17 version
template<typename T>
std::ostream &operator<<(std::ostream &out, const vector<T> &container) {
    char separator = (std::is_arithmetic_v<T> || std::is_same_v<T, int_mod>)
                     ? ' '
                     : '\n';

    for (const auto &i: container) {
        out << i << separator;
    }
    return out;
}

template<typename T>
bool mini(T &a, const T &b) {
    if (a > b) {
        a = b;
        return true;
    }
    return false;
}

template<typename T>
bool maxi(T &a, const T &b) {
    if (a < b) {
        a = b;
        return true;
    }
    return false;
}

template<typename T>
T binpow(const T &a, ll exp) {
    T res(1);
    T base = a;
    while (exp > 0) {
        if (exp & 1)
            res *= base;
        base *= base;
        exp /= 2;
    }
    return res;
}

struct int_mod {
    static const int MOD = 998'244'353;
private:
    int val;

public:
    int_mod() : val(0) {}

    int_mod(int x) {
        val = (x % MOD + MOD) % MOD;
    }

    int_mod(ll x) {
        val = (int) ((x % MOD + MOD) % MOD);
    }

    operator int() const {
        return val;
    }

    int_mod &operator+=(const int_mod &other) {
        val += other.val;
        if (val >= MOD)
            val -= MOD;
        return *this;
    }

    int_mod &operator-=(const int_mod &other) {
        val -= other.val;
        if (val < 0)
            val += MOD;
        return *this;
    }

    int_mod &operator*=(const int_mod &other) {
        val = static_cast<int>(static_cast<long long>(val) * other.val % MOD);
        return *this;
    }

    int_mod &operator/=(const int_mod &other) {
        return *this *= other.inv();
    }

    int_mod inv() const {
        return binpow(*this, MOD - 2);
    }

    friend int_mod operator+(int_mod a, const int_mod &b) {
        a += b;
        return a;
    }

    friend int_mod operator+(int_mod a, int b) {
        a += b;
        return a;
    }

    friend int_mod operator-(int_mod a, const int_mod &b) {
        a -= b;
        return a;
    }

    friend int_mod operator-(int_mod a, int b) {
        a -= b;
        return a;
    }

    friend int_mod operator*(int_mod a, const int_mod &b) {
        a *= b;
        return a;
    }

    friend int_mod operator*(int_mod a, int b) {
        a *= b;
        return a;
    }

    friend int_mod operator/(int_mod a, const int_mod &b) {
        a /= b;
        return a;
    }

    friend int_mod operator/(int_mod a, int_mod b) {
        a /= b;
        return a;
    }

    friend std::ostream &operator<<(std::ostream &os, const int_mod &m) {
        return os << m.val;
    }

    friend std::istream &operator>>(std::istream &is, int_mod &m) {
        int x;
        is >> x;
        m = int_mod(x);
        return is;
    }
};

const int inf = 1e9;

const int maxn = 1e7 + 1;

int cost[maxn];

unordered_map<ll, int> ans;

int get_cost(ll x) {
    if (x < maxn) {
        return cost[x];
    }
    if (x == 0) {
        return 1;
    }
    int r = 0;
    while (x > 0) {
        ++r;
        x /= 10;
    }
    return r;
}


const int INF = 1'000'000'000;
constexpr int BAD = 600;

int rec(ll x, ll can) {
    auto it = ans.find(x);
    if (it != ans.end()) return it->second;

    if (can < 0) {
        return INF;
    }
    int c ;
    int r;
    if (x & 1) {
        c = get_cost(x * 3 + 1);
        r = rec(x * 3 + 1, can - c);
    } else {
        c = get_cost(x / 2);
        r = rec(x / 2, can - c);
    }
    if (r == INF) {
        return INF;
    }
    r += c;
    ans[x] = r;
    return r;
}

void init() {
    cost[0] = 0;
    cost[1] = 1;
    for (int i = 0; i < maxn; ++i) {
        cost[i] = 1 + cost[i / 10];
    }

    ans[1] = 0;
}

void solve() {
    int can = 600;
    bool fst = true;
    while (true) {
        string sx;
        cin >> sx;
        if (sx.size() > 18) {
            cout << "collatz" << endl;
            continue;
        }
        ll x = std::stol(sx);
//        cin >> x;
        if (x == 0) {
            exit(0);
        }
        if (x == 1) {
            return;
        }
        if (!fst) {
            can -= get_cost(x);
        } else {
            fst = false;
        }
        if ((x & 1) == 0) {
            cout << "collatz" << endl;
        } else {
            int r = rec(x, can);
            if (r > can) {
                cout << "random" << endl;
            } else {
                cout << "collatz" << endl;
            }
        }
    }

}

signed main() {
#ifdef pskobx
//    freopen("input", "r", stdin);
//    freopen("out", "w", stdout);
#endif
#ifndef pskobx
//    std::ios::sync_with_stdio(false);
//    cin.tie(nullptr);
#endif

    int tests = 1;
    cin >> tests;

    init();

    while (tests--) {
        solve();
        cout << '\n';
    }
}

