#include <bits/stdc++.h>
// #pragma comment(linker, "/STACK:16777216")
#pragma GCC optimize("O3")
#pragma GCC target("popcnt,lzcnt,abm")

using namespace std;

using uint = unsigned int;
using ll = long long;
using ull = unsigned long long;
using dbl = double;
using ld = long double;
using pii = pair<int, int>;
using pll = pair<ll, ll>;
using pdd = pair<dbl, dbl>;
using pld = pair<ld, ld>;

// #include <ext/pb_ds/assoc_container.hpp>
// #include <ext/pb_ds/tree_policy.hpp>
// using namespace __gnu_pbds;
// typedef tree<int, null_type, less<>, rb_tree_tag, tree_order_statistics_node_update> ordered_set;

#define ft first
#define sc second
#define pb push_back
#define all(x) (x).begin(), (x).end()
#define rall(x) (x).rbegin(), (x).rend()

const int MAXN = 1e7 + 1;
const int MAX_TIMES = 50;
const int AVG_MEAN = 1000;
const int JUMPS = 300;
array<int, MAXN> calc;

int collatz(ll x, bool sample = false, int jump = 0) {
    if (sample && jump >= JUMPS) return INT_MAX;
    if (sample && x < calc.size() && calc[x] != AVG_MEAN) {
        return calc[x];
    }
    if (x % 2 == 1 && x >= LLONG_MAX / 3 - 1) {
        return INT_MAX;
    }
    if (x < MAXN) {
        if (calc[x] != -1) return calc[x];
        auto next = (x % 2 == 0) ? (x / 2) : (3 * x + 1);
        auto res = collatz(next, sample, jump + 1);
        if (res == INT_MAX) {
            calc[x] = INT_MAX;
            return INT_MAX;
        } else {
            calc[x] = 1 + res;
            return calc[x];
        }
    }
    auto next = (x % 2 == 0) ? x / 2 : 3 * x + 1;
    return collatz(next, sample, jump + 1);
}

int get_mean(int l, int r) {
    if (r > MAXN) return AVG_MEAN;
    return (calc[r] - calc[l - 1]) / (r - l + 1);
}

void precalc() {
    calc.fill(-1);
    calc[1] = 0;
    for (int x = 2; x < MAXN; x++) {
        collatz(x);
        if (calc[x] == INT_MAX) calc[x] = AVG_MEAN;
    }
    for (int x = 1; x < MAXN; x++) {
        calc[x] += calc[x - 1];
    }
}

void print_collatz() {
    cout << "collatz" << endl;
}

void print_random() {
    cout << "random" << endl;
}

void solve() {
    int times = 0;
    while (true) {
        string s;
        cin >> s;
        if (s.length() > 17) {
            if ((int) (s.back() - '0') % 2 == 0 || times < MAX_TIMES) {
                print_collatz();
                times++;
            } else {
                print_random();
                times = 0;
            }
            continue;
        }
        ll x = stoll(s);
        if (x == 0) {
            exit(0);
        } else if (x == 1) {
            return;
        } else {
            if (x < calc.size()) {
                int value = get_mean(x, x);
                if (value < 600) {
                    print_collatz();
                } else {
                    int jumps = collatz(x, true, 0);
                    value = min(value, jumps);
                    if (get_mean(3 * x + 1, 6 * x) < value) {
                        print_random();
                    } else {
                        print_collatz();
                    }
                }
            } else {
                if (times < MAX_TIMES) {
                    print_collatz();
                    times++;
                } else {
                    int jumps = collatz(x, true, 0);
                    if (jumps < AVG_MEAN) {
                        print_collatz();
                        times++;
                    } else {
                        print_random();
                        times = 0;
                    }
                }
            }
        }
    }
}

signed main() {
    std::ios::sync_with_stdio(false);
    cin.tie(nullptr);

    // std::freopen("", "r", stdin);
    // std::freopen("", "w", stdout);

    precalc();
    int t = 1;
    cin >> t;
    while (t--) solve();
    return 0;
}