#include <iostream>
#include <vector>
#include <climits>
#include <algorithm>
#include <map>
#include <numeric>
#include <math.h>
#include <cmath>
#include <unordered_map>
#include <string>
#include <stack>
#include <queue>
#include <iomanip>
#include <set>
using namespace std;

using ll = long long;
using ld = long double;
const ll N = 1e7 + 1;

map < ll, ll > c;

ll collatz(ll n) {
    if(n >= N) {
        return INT_MAX;
    }
    if(n == 1) {
        return 1;
    }
    if(c[n]) {
        return c[n];
    }
    if(n % 2) {
        return c[n] = collatz(3 * n + 1);
    }
    return c[n] = collatz(n / 2);
}

void solve() {
    for(int i = 2; i < N; i++) {
        c[i] = collatz(i);
    }
    ll x0;
    while(true) {
        cin >> x0;
        if(x0 == 0) {
            exit(0);
        }
        if(x0 == 1) {
            break;
        }
        ll res = 0, C = c[x0];
        for(ll i = 3 * x0 + 1; i <= 3 * x0 + 500; i++) {  
            res = max(res, c[i]);
        }
        if(res < C) {
            cout << "random" << endl;
        } else {
            cout << "collatz" << endl;
        }
    }
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout << setprecision(15);
    ll t = 1;
    cin >> t;
    while (t--) {
        solve();
    }
    return 0;
}