#include <iostream>
#include <vector>

void dp(
    int i, int m, int k,
    long long int h,
    long long int w,
    std::vector<long long int> &values,
    long long int &min_area,
    long long int &max_area)
{
    if (i >= values.size())
    {
        if (m == 0 && k == 0)
        {
            min_area = std::min(min_area, h * w);
            max_area = std::max(max_area, h * w);
        }
        return;
    }

    if (m > 0)
    {
        dp(i + 1, m - 1, k, h + values[i], w, values, min_area, max_area);
    }
    if (k > 0)
    {
        dp(i + 1, m, k - 1, h, w + values[i], values, min_area, max_area);
    }
}

int main()
{
    int n;
    std::cin >> n;
    std::vector<long long int> values(n);
    for (auto &i : values)
    {
        std::cin >> i;
    }

    long long int min_area = 1e10;
    long long int max_area = 0;
    int m = 1, k = n - m;
    do
    {
        dp(0, m, k, 0, 0, values, min_area, max_area);
        ++m;
        --k;
    } while (m < n);
    std::cout << min_area << ' ' << max_area;

    return 0;
}
