import sys


def should_use_random(x):
    # Консервативная стратегия
    if x < 500:
        return False

    # Только для чисел, которые точно ведут к сильному росту
    if x % 4 == 3 and x > 10000:
        return True

    # Или для очень больших чисел
    if x > 5 * 10 ** 6:
        return (x % 7 == 0)

    return False


def main():
    t = int(sys.stdin.readline())

    for _ in range(t):
        x = int(sys.stdin.readline())

        while True:
            if x == 1:
                break

            if should_use_random(x):
                print("random")
            else:
                print("collatz")
            sys.stdout.flush()

            x = int(sys.stdin.readline())
            if x == 0:
                return


if __name__ == "__main__":
    main()