import sys


def collatz_steps(x, limit=50):
    """Оцениваем, сколько шагов до уменьшения числа в 2 раза (примерно)"""
    steps = 0
    orig = x
    while x > orig // 2 and steps < limit:
        if x % 2 == 0:
            x //= 2
        else:
            x = 3 * x + 1
        steps += 1
    return steps


def should_use_random(x):
    # Для очень маленьких чисел всегда collatz
    if x <= 100:
        return False

    # Если число уже близко к степени двойки - collatz выгоднее
    if (x & (x - 1)) == 0:  # степень двойки
        return False

    # Если следующее число Коллатца будет сильно меньше
    if x % 2 == 0 and x // 2 <= 100:
        return False

    # Числа вида 3 mod 4 часто ведут к росту
    if x % 4 == 3:
        return True

    # Оцениваем "плохость" последовательности
    steps_to_halve = collatz_steps(x)
    if steps_to_halve > 20:
        return True

    # Для очень больших чисел чаще используем random
    if x > 10 ** 6:
        return (x % 3 == 0)

    return False


def main():
    input = sys.stdin.readline
    t = int(input().strip())

    for _ in range(t):
        x = int(input().strip())

        while x != 1:
            if should_use_random(x):
                print("random")
            else:
                print("collatz")
            sys.stdout.flush()

            x = int(input().strip())
            if x == 0:
                return


if __name__ == "__main__":
    main()