def cross(p0, p1, p2):
    return (p1[0] - p0[0]) * (p2[1] - p0[1]) - (p1[1] - p0[1]) * (p2[0] - p0[0])

def dist(p1, p2):
    return (p1[0] - p2[0]) ** 2 + (p1[1] - p2[1]) ** 2

def calc(ps):
    n = len(ps)
    if n <= 2:
        return ps

    ps.sort()
    low = []
    for p in ps:
        while len(low) >= 2 and cross(low[-2], low[-1], p) <= 0:
            low.pop()
        low.append(p)
    upp = []
    for p in ps[::-1]:
        while len(upp) >= 2 and cross(upp[-2], upp[-1], p) <= 0:
            upp.pop()
        upp.append(p)
    return low[:-1] + upp[:-1]


n = int(input())
ps = []
for _ in range(n):
    x, y = map(int, input().split())
    ps.append((x, y))

ans = calc(ps)
m = len(ans)

if m < 2:
    p1, p2 = ps[0], ps[1]
else:
    max_d_sq = -1
    p1, p2 = None, None

    for i in range(m):
        for j in range(i + 1, m):
            d_sq = dist(ans[i], ans[j])
            if d_sq > max_d_sq:
                max_d_sq = d_sq
                p1 = ans[i]
                p2 = ans[j]

a = p2[0] - p1[0]
b = p2[1] - p1[1]
c1 = -a * p1[0] - b * p1[1]
c2 = -a * p2[0] - b * p2[1]

print(a, b, c1)
print(a, b, c2)
