import math

length = int(input())
points = []
for i in range(length):
    points.append(list(map(int, input().split(" "))))

max_dist = [ 0, points[0], points[1] ]
for i in range(length):
    for j in range(i+1, length):
        dist = math.dist(points[i], points[j])
        if max_dist[0] < dist:
            max_dist = [ dist, points[i], points[j] ]

_, p1, p2 = max_dist

if p1[0] == p2[0]:
    k_perp = 0
else:
    k = (p2[1] - p1[1]) / (p2[0] - p1[0])
    
    if k == 0:
        k_perp = float("inf")
    else:
        k_perp = -1 / k

def kb_to_abc(k, b):
    A = -k      # Коэффициент при x
    B = 1       # Коэффициент при y
    C = -b      # Свободный член

    return [A, B, C]

if k_perp == float("inf"):
    # В ответе будут вертикальные прямые
    print(f"1 0 {p1[0]}")
    print(f"1 0 {p2[0]}")
else:
    b_perp1 = p1[1] - k_perp * p1[0]
    b_perp2 = p2[1] - k_perp * p2[0]
    ans1 = kb_to_abc(k_perp, b_perp1)
    ans2 = kb_to_abc(k_perp, b_perp2)

    print(" ".join(list(map(lambda x: str(int(x)), ans1))))
    print(" ".join(list(map(lambda x: str(int(x)), ans2))))


